@php
    $settings = \App\Models\Utility::settings();
    $creatorId = \Auth::user()->creatorId();
    $company_state = strtolower(trim($settings['company_state'] ?? 'defaultstate'));
    $customer_state = strtolower(trim($customer->billing_state ?? ''));
    $isSameState = $company_state === $customer_state;
@endphp

@extends('layouts.admin')

@section('page-title')
    {{ __(' Detail') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('ewaybill.index') }}">{{ __('EWayBill') }}</a></li>
    <li class="breadcrumb-item">{{ \Auth::user()->ebillNumberFormat($ewaybill->ewaybill_id) }}</li>
@endsection

@push('css-page')
    <style>
        #card-element {
            border: 1px solid #a3afbb !important;
            border-radius: 10px !important;
            padding: 10px !important;
        }
        .invoice-body td {
            vertical-align: middle;
        }
        .invoice-body .table-sm td {
            padding: 0.2rem;
        }
    </style>
@endpush

@push('script-page')
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script src="https://api.ravepay.co/flwv3-pug/getpaidx/api/flwpbf-inline.js"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script type="text/javascript">
        @if (
            $ewaybill->getDue() > 0 &&
            !empty($company_payment_setting) &&
            $company_payment_setting['is_stripe_enabled'] == 'on' &&
            !empty($company_payment_setting['stripe_key']) &&
            !empty($company_payment_setting['stripe_secret'])
        )
            var stripe = Stripe('{{ $company_payment_setting['stripe_key'] }}');
            var elements = stripe.elements();
            var style = {
                base: {
                    fontSize: '14px',
                    color: '#32325d',
                },
            };
            var card = elements.create('card', { style: style });
            card.mount('#card-element');
            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                stripe.createToken(card).then(function(result) {
                    if (result.error) {
                        $("#card-errors").html(result.error.message);
                        show_toastr('error', result.error.message, 'error');
                    } else {
                        stripeTokenHandler(result.token);
                    }
                });
            });
            function stripeTokenHandler(token) {
                var form = document.getElementById('payment-form');
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'stripeToken');
                hiddenInput.setAttribute('value', token.id);
                form.appendChild(hiddenInput);
                form.submit();
            }
        @endif

        @if (isset($company_payment_setting['paystack_public_key']))
            $(document).on("click", "#pay_with_paystack", function() {
                $('#paystack-payment-form').ajaxForm(function(res) {
                    var amount = res.total_price;
                    if (res.flag == 1) {
                        var paystack_callback = "{{ url('/ewaybill/paystack') }}";
                        var handler = PaystackPop.setup({
                            key: '{{ $company_payment_setting['paystack_public_key'] }}',
                            email: res.email,
                            amount: res.total_price * 100,
                            currency: res.currency,
                            ref: 'pay_ref_id' + Math.floor((Math.random() * 1000000000) + 1),
                            metadata: {
                                custom_fields: [{
                                    display_name: "Email",
                                    variable_name: "email",
                                    value: res.email,
                                }]
                            },
                            callback: function(response) {
                                window.location.href = paystack_callback + '/' + response.reference + '/' + '{{ encrypt($ewaybill->id) }}' + '?amount=' + amount;
                            },
                            onClose: function() {}
                        });
                        handler.openIframe();
                    } else if (res.flag == 2) {
                        toastrs('Error', res.msg, 'msg');
                    } else {
                        toastrs('Error', res.message, 'msg');
                    }
                }).submit();
            });
        @endif

        @if (isset($company_payment_setting['flutterwave_public_key']))
            $(document).on("click", "#pay_with_flaterwave", function() {
                $('#flaterwave-payment-form').ajaxForm(function(res) {
                    if (res.flag == 1) {
                        var amount = res.total_price;
                        var API_publicKey = '{{ $company_payment_setting['flutterwave_public_key'] }}';
                        var nowTim = "{{ date('d-m-Y-h-i-a') }}";
                        var flutter_callback = "{{ url('/ewaybill/flaterwave') }}";
                        var x = getpaidSetup({
                            PBFPubKey: API_publicKey,
                            customer_email: '{{ Auth::user()->email }}',
                            amount: res.total_price,
                            currency: '{{ App\Models\Utility::getValByName('site_currency') }}',
                            txref: nowTim + '__' + Math.floor((Math.random() * 1000000000)) + 'fluttpay_online-' + '{{ date('Y-m-d') }}' + '?amount=' + amount,
                            meta: [{
                                metaname: "payment_id",
                                metavalue: "id"
                            }],
                            onclose: function() {},
                            callback: function(response) {
                                var txref = response.tx.txRef;
                                if (response.tx.chargeResponseCode == "00" || response.tx.chargeResponseCode == "0") {
                                    window.location.href = flutter_callback + '/' + txref + '/' + '{{ \Illuminate\Support\Facades\Crypt::encrypt($ewaybill->id) }}';
                                }
                                x.close();
                            }
                        });
                    } else if (res.flag == 2) {
                        toastrs('Error', res.msg, 'msg');
                    } else {
                        toastrs('Error', res.message, 'msg');
                    }
                }).submit();
            });
        @endif

        @if (isset($company_payment_setting['razorpay_public_key']))
            $(document).on("click", "#pay_with_razorpay", function() {
                $('#razorpay-payment-form').ajaxForm(function(res) {
                    if (res.flag == 1) {
                        var amount = res.total_price;
                        var razorPay_callback = '{{ url('/ewaybill/razorpay') }}';
                        var totalAmount = res.total_price * 100;
                        var coupon_id = res.coupon;
                        var options = {
                            "key": "{{ $company_payment_setting['razorpay_public_key'] }}",
                            "amount": totalAmount,
                            "name": 'Plan',
                            "currency": '{{ App\Models\Utility::getValByName('site_currency') }}',
                            "description": "",
                            "handler": function(response) {
                                window.location.href = razorPay_callback + '/' + response.razorpay_payment_id + '/' + '{{ \Illuminate\Support\Facades\Crypt::encrypt($ewaybill->id) }}' + '?amount=' + amount;
                            },
                            "theme": {
                                "color": "#528FF0"
                            }
                        };
                        var rzp1 = new Razorpay(options);
                        rzp1.open();
                    } else if (res.flag == 2) {
                        toastrs('Error', res.msg, 'msg');
                    } else {
                        toastrs('Error', res.message, 'msg');
                    }
                }).submit();
            });
        @endif

        $('.cp_link').on('click', function() {
            var value = $(this).attr('data-link');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(value).select();
            document.execCommand("copy");
            $temp.remove();
            show_toastr('success', '{{ __('Link Copy on Clipboard') }}', 'success');
        });
    </script>
@endpush

@section('content')
@can('send invoice')
        @if ($ewaybill->status != 4)
            <div class="row">
                <div class="col-12">
                    <div class="bill-timeline-card mb-4">
                        <div class="row timeline-wrapper">
                            <div class="col-xl-4 col-md-5 col-sm-7 create-invoice invoice">
                                <div class="progress mb-3">
                                    <div class="progress-value"></div>
                                </div>
                                <div class="bill-timeline-inner d-flex gap-3">
                                    <div class="timeline-icon d-flex align-items-center justify-content-center">
                                        <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_69_767)">
                                                <path d="M9.15642 18C8.92315 18 8.69942 17.9074 8.53447 17.7426C8.36952 17.5777 8.27686 17.3542 8.27686 17.1211V0.878906C8.27686 0.645806 8.36952 0.422253 8.53447 0.257426C8.69942 0.0925988 8.92315 0 9.15642 0C9.3897 0 9.61342 0.0925988 9.77837 0.257426C9.94332 0.422253 10.036 0.645806 10.036 0.878906V17.1211C10.036 17.3542 9.94332 17.5777 9.77837 17.7426C9.61342 17.9074 9.3897 18 9.15642 18Z" fill="white" />
                                                <path d="M17.2838 9.87891H1.02947C0.796193 9.87891 0.572472 9.78631 0.407521 9.62148C0.242571 9.45665 0.149902 9.2331 0.149902 9C0.149902 8.7669 0.242571 8.54335 0.407521 8.37852C0.572472 8.21369 0.796193 8.12109 1.02947 8.12109H17.2838C17.5171 8.12109 17.7408 8.21369 17.9058 8.37852C18.0707 8.54335 18.1634 8.7669 18.1634 9C18.1634 9.2331 18.0707 9.45665 17.9058 9.62148C17.7408 9.78631 17.5171 9.87891 17.2838 9.87891Z" fill="white" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_69_767">
                                                    <rect width="18.0135" height="18" fill="white" transform="translate(0.149902)" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                    <div class="timeline-content text-start">
                                        <h5 class="mb-2">{{ __('Create EWayBill') }}</h5>
                                        <p class="text-muted mb-2">
                                            {{ __('Created on ') }}{{ \Auth::user()->dateFormat($ewaybill->issue_date) }}
                                        </p>
                                        @can('edit invoice')
                                        @if (!in_array($ewaybill->status, [3, 4])) {{-- 3: Partially Paid, 4: Paid --}}
                                            <a href="{{ route('ewaybill.edit', \Crypt::encrypt($ewaybill->id)) }}"
                                               class="btn btn-sm d-inline-flex align-items-center gap-2" data-bs-toggle="tooltip"
                                               data-original-title="{{ __('Edit') }}">
                                                <i class="ti ti-pencil"></i>{{ __('Edit') }}
                                            </a>
                                            @endif
                                        @endcan
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-md-5 col-sm-7 send-invoice invoice">
                                <div class="progress mb-3">
                                    <div class="{{ $ewaybill->status !== 0 ? 'progress-value' : '' }}"></div>
                                </div>
                                <div class="bill-timeline-inner d-flex gap-3">
                                    <div class="timeline-icon d-flex align-items-center justify-content-center">
                                        <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                  d="M13.3797 5.12359L7.43524 9.24773L1.21757 7.17645C0.783563 7.03159 0.491171 6.62471 0.493668 6.16758C0.496198 5.71046 0.791942 5.30607 1.22762 5.16627L17.1241 0.0508648C17.502 -0.0705155 17.9167 0.0290971 18.1974 0.309582C18.4781 0.590066 18.5778 1.00447 18.4563 1.38208L13.337 17.2666C13.1971 17.702 12.7924 17.9975 12.335 18C11.8775 18.0025 11.4703 17.7103 11.3253 17.2767L9.24246 11.0335L13.3797 5.12359Z"
                                                  fill="white" />
                                        </svg>
                                    </div>
                                    <div class="timeline-content text-start">
                                        <h5 class="mb-2">{{ __('Send EWayBill') }}</h5>
                                        <p class="text-muted mb-2">
                                            @if ($ewaybill->status != 0)
                                                {{ __('Sent on') }} {{ \Auth::user()->dateFormat($ewaybill->send_date) }}
                                            @else
                                                @can('send invoice')
                                                    <small>{{ __('Status') }} : {{ __('Not Sent') }}</small>
                                                @endcan
                                            @endif
                                        </p>
                                        @if ($ewaybill->status == 0)
                                            @can('send invoice')
                                                <a href="{{ route('ewaybill.sent', $ewaybill->id) }}"
                                                   class="btn btn-sm d-inline-flex align-items-center gap-2 btn-warning border-0"
                                                   data-bs-toggle="tooltip" data-original-title="{{ __('Mark Sent') }}">
                                                    <i class="ti ti-send"></i>{{ __('Send') }}
                                                </a>
                                            @endcan
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-md-5 col-sm-7 get-paid invoice">
                                <div class="progress mb-3">
                                    <div class="{{ $ewaybill->status == 4 ? 'progress-value' : '' }}"></div>
                                </div>
                                <div class="bill-timeline-inner d-flex gap-3">
                                    <div class="timeline-icon d-flex align-items-center justify-content-center">
                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.386719 5.30859H8.47266V6.36328H0.386719V5.30859Z" fill="white" />
                                            <path d="M8.47266 7.06641H0.386719V9.52734H8.47266V7.06641ZM3.72656 8.47266H1.79297C1.5988 8.47266 1.44141 8.31526 1.44141 8.12109C1.44141 7.92693 1.5988 7.76953 1.79297 7.76953H3.72656C3.92073 7.76953 4.07812 7.92693 4.07812 8.12109C4.07812 8.31526 3.92073 8.47266 3.72656 8.47266ZM7.06641 8.47266H5.13281C4.93864 8.47266 4.78125 8.31526 4.78125 8.12109C4.78125 7.92693 4.93864 7.76953 5.13281 7.76953H7.06641C7.26057 7.76953 7.41797 7.92693 7.41797 8.12109C7.41797 8.31526 7.26057 8.47266 7.06641 8.47266Z" fill="white" />
                                            <path d="M10.5981 3.55005C10.5708 3.55131 4.92694 3.55075 3.55078 3.55086V4.60555H9.17578V10.2305H3.55078V14.4493H14.4492V7.06648C12.4352 7.06648 10.776 5.51852 10.5981 3.55005Z" fill="white" />
                                            <path d="M10.598 2.84846C10.7029 1.68683 11.3235 0.671766 12.2291 0.0351562H4.95703C4.18148 0.0351562 3.55078 0.665859 3.55078 1.44141V2.84766C4.94831 2.84776 10.5702 2.8472 10.598 2.84846ZM9.52734 1.79297H7.76953C7.57536 1.79297 7.41797 1.63557 7.41797 1.44141C7.41797 1.24724 7.57536 1.08984 7.76953 1.08984H9.52734C9.72148 1.08984 9.87891 1.24724 9.87891 1.44141C9.87891 1.63557 9.72148 1.79297 9.52734 1.79297Z" fill="white" />
                                            <path d="M3.55078 16.5586C3.55078 17.3341 4.18148 17.9648 4.95703 17.9648H13.043C13.8185 17.9648 14.4492 17.3341 14.4492 16.5586V15.1523H3.55078V16.5586ZM8.12109 16.207H9.87891C10.073 16.207 10.2305 16.3645 10.2305 16.5586C10.2305 16.7527 10.073 16.9102 9.87891 16.9102H8.12109C7.92703 16.9102 7.76953 16.7527 7.76953 16.5586C7.76953 16.3645 7.92703 16.207 8.12109 16.207Z" fill="white" />
                                            <path d="M14.4492 0.0351562C12.7017 0.0351562 11.2852 1.45174 11.2852 3.19922C11.2852 4.9467 12.7017 6.36328 14.4492 6.36328C16.1967 6.36328 17.6133 4.9467 17.6133 3.19922C17.6133 1.45174 16.1967 0.0351562 14.4492 0.0351562ZM16.0162 2.52496L14.1705 4.37066C14.0331 4.50795 13.8106 4.50795 13.6733 4.37066L12.8822 3.57964C12.7449 3.44236 12.7449 3.21975 12.8822 3.08243C13.0196 2.94514 13.2421 2.94514 13.3794 3.08243L13.9219 3.62489L15.519 2.02778C15.6563 1.89049 15.8788 1.89049 16.0162 2.02778C16.1535 2.16506 16.1535 2.38767 16.0162 2.52496Z" fill="white" />
                                        </svg>
                                    </div>
                                    <div class="timeline-content text-start">
                                        <h5 class="mb-2">{{ __('Get Paid') }}</h5>
                                        <p class="text-muted mb-2">
                                            {{ __('Status') }} : {{ __('Awaiting payment') }}
                                        </p>
                                        @if ($ewaybill->status != 0)
                                            @can('create payment invoice')
                                                <a href="#" data-url="{{ route('ewaybill.payments', $ewaybill->id) }}"
                                                   data-ajax-popup="true" data-title="{{ __('Add Payment') }}"
                                                   class="btn btn-sm d-inline-flex align-items-center gap-2"
                                                   data-bs-toggle="tooltip" data-original-title="{{ __('Add Payment') }}">
                                                    <i class="ti ti-report-money"></i>{{ __('Add Payment') }}
                                                </a>
                                            @endcan
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endcan

    @if (Gate::check('show invoice'))
        @if ($ewaybill->status != 0)
            <div class="row justify-content-between align-items-center mb-3">
                <div class="d-flex flex-wrap align-items-center justify-content-end gap-2">
                    @if (!empty($creditnote))
                        <div class="all-button-box">
                            <a href="#" class="btn btn-sm btn-primary"
                               data-url="{{ route('ewaybill.credit.note', $ewaybill->id) }}" data-ajax-popup="true"
                               data-title="{{ __('Add Credit Note') }}">
                                {{ __('Add Credit Note') }}
                            </a>
                        </div>
                    @endif
                    @if ($ewaybill->status != 4)
                        <div class="all-button-box">
                            <a href="{{ route('ewaybill.payment.reminder', $ewaybill->id) }}"
                               class="btn btn-sm btn-primary">{{ __('Receipt Reminder') }}</a>
                        </div>
                    @endif
                    <div class="all-button-box">
                        <a href="{{ route('ewaybill.resent', $ewaybill->id) }}"
                           class="btn btn-sm btn-primary">{{ __('Resend EWayBill') }}</a>
                    </div>
                    <div class="all-button-box">
                        <a href="{{ route('ewaybill.pdf', Crypt::encrypt($ewaybill->id)) }}" target="_blank"
                           class="btn btn-sm btn-primary">{{ __('Download') }}</a>
                    </div>
                </div>
            </div>
        @endif
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="ewaybill">
                        <div class="ewaybill-print">
                            <div class="row ewaybill-title mt-2">
                                <div class="col-xs-12 col-sm-12 col-nd-6 col-lg-6 col-12">
                                    <h4>{{ __('E-Way Bill') }}</h4>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-nd-6 col-lg-6 col-12 text-end">
                                    <h4 class="ewaybill-number">{{ \Auth::user()->ebillNumberFormat($ewaybill->ewaybill_id) }}</h4>
                                </div>
                                <div class="col-12">
                                    <hr>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col text-end">
                                    <div class="d-flex align-items-center justify-content-end">
                                        <div class="me-4">
                                            <small>
                                                <strong>{{ __('Issue Date') }} :</strong><br>
                                                {{ \Auth::user()->dateFormat($ewaybill->issue_date) }}<br><br>
                                            </small>
                                        </div>
                                        <div>
                                            <small>
                                                <strong>{{ __('Due Date') }} :</strong><br>
                                                {{ \Auth::user()->dateFormat($ewaybill->due_date) }}<br><br>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <small class="font-style">
                                        <strong>{{ __('Billed To') }} :</strong><br>
                                        @if (!empty($customer->billing_name))
                                            {{ $customer->billing_name }}<br>
                                            {{ $customer->billing_address ?? '' }}<br>
                                            {{ $customer->billing_city ?? '' . ', ' }}<br>
                                            {{ $customer->billing_state ?? '', ', ' }}{{ $customer->billing_zip ?? '' }}<br>
                                            {{ $customer->billing_country ?? '' }}<br>
                                            {{ $customer->billing_phone ?? '' }}<br>
                                            @if ($settings['vat_gst_number_switch'] == 'on')
                                                @if (!empty($settings['tax_type']) && !empty($settings['vat_number']))
                                                    {{ $settings['tax_type'] . ' ' . __('Number') }} : {{ $settings['vat_number'] }} <br>
                                                @endif
                                                <strong>{{ __('Tax Number') }} :</strong> {{ $customer->tax_number ?? '' }}
                                            @endif
                                        @else
                                            -
                                        @endif
                                    </small>
                                </div>
                                @if (App\Models\Utility::getValByName('shipping_display') == 'on')
                                    <div class="col">
                                        <small>
                                            <strong>{{ __('Shipped To') }} :</strong><br>
                                            @if (!empty($customer->shipping_name))
                                                {{ $customer->shipping_name }}<br>
                                                {{ $customer->shipping_address ?? '' }}<br>
                                                {{ $customer->shipping_city ?? '' . ', ' }}<br>
                                                {{ $customer->shipping_state ?? '' . ', ' }}{{ $customer->shipping_zip ?? '' }}<br>
                                                {{ $customer->shipping_country ?? '' }}<br>
                                                {{ $customer->shipping_phone ?? '' }}<br>
                                            @else
                                                -
                                            @endif
                                        </small>
                                    </div>
                                @endif
                                <div class="col">
                                    <div class="float-end mt-3">
                                        @if ($settings['ewaybill_qr_display'] == 'on')
                        {!! DNS2D::getBarcodeHTML(route('ewaybill.link.copy', \Crypt::encrypt($ewaybill->id)), 'QRCODE', 2, 2) !!}
                @endif
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col">
                                    <small>
                                        <strong>{{ __('Status') }} :</strong><br>
                                        @if ($ewaybill->status == 0)
                                            <span class="badge bg-primary p-2 px-3 rounded">{{ __(\App\Models\ewaybill::$statues[$ewaybill->status]) }}</span>
                                        @elseif($ewaybill->status == 1)
                                            <span class="badge bg-warning p-2 px-3 rounded">{{ __(\App\Models\ewaybill::$statues[$ewaybill->status]) }}</span>
                                        @elseif($ewaybill->status == 2)
                                            <span class="badge bg-danger p-2 px-3 rounded">{{ __(\App\Models\ewaybill::$statues[$ewaybill->status]) }}</span>
                                        @elseif($ewaybill->status == 3)
                                            <span class="badge bg-info p-2 px-3 rounded">{{ __(\App\Models\ewaybill::$statues[$ewaybill->status]) }}</span>
                                        @elseif($ewaybill->status == 4)
                                            <span class="badge bg-success p-2 px-3 rounded">{{ __(\App\Models\ewaybill::$statues[$ewaybill->status]) }}</span>
                                        @endif
                                    </small>
                                </div>
                                @if (!empty($customFields) && count($ewaybill->customField) > 0)
                                    @foreach ($customFields as $field)
                                        <div class="col text-end">
                                            <small>
                                                <strong>{{ $field->name }} :</strong><br>
                                                {{ !empty($ewaybill->customField) ? $ewaybill->customField[$field->id] : '-' }}
                                                <br><br>
                                            </small>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="font-weight-bold">{{ __('Product Summary') }}</div>
                                    <small>{{ __('All items here cannot be deleted.') }}</small>
                                    <div class="table-responsive mt-2">
                                        <table class="table mb-0 ewaybill-body">
    <thead>
        <tr>
            <th class="text-dark" data-width="40">#</th>
            <th class="text-dark">{{ __('Product') }}</th>
            <th class="text-dark">{{ __('Quantity') }}</th>
            <th class="text-dark">{{ __('Rate') }}</th>
            <th class="text-dark">{{ __('Discount') }}</th>
            <th class="text-dark">{{ __('Tax') }}</th>
            <th class="text-dark">{{ __('Description') }}</th>
            <th class="text-end text-dark" width="12%">
                {{ __('Price') }}<br>
                <small class="text-danger font-weight-bold">{{ __('after tax & discount') }}</small>
            </th>
        </tr>
    </thead>
    <tbody>
        @php
            $totalQuantity = 0;
            $totalPrice = 0;
            $totalTaxPrice = 0;
            $totalDiscount = 0;
            $taxSummary = [];
        @endphp

        @foreach ($items as $key => $item)
            @php
                $productName = $item->product;
                $totalQuantity += $item->quantity;
                $totalPrice += $item->price;
                $totalDiscount += $item->discount;
                $taxableAmount =  ($item->price ?? 0) * ($item->quantity ?? 0) -  ($item->discount ?? 0);
                $itemTaxPrice = 0;
            @endphp
            <tr>
                <td>{{ $key + 1 }}</td>
                <td>{{ $productName->name ?? '-' }}</td>
                <td>{{ $item->quantity . ' (' . ($productName->unit->name ?? '-') . ')' }}</td>
                <td>{{ \Auth::user()->priceFormat($item->price) }}</td>
                <td>{{ \Auth::user()->priceFormat($item->discount) }}</td>
                <td>
    @php
        // Decode tax IDs from JSON or fallback to comma string
        $taxData = json_decode($item->tax, true);
        if (!is_array($taxData) && !empty($item->tax)) {
            $taxData = explode(',', $item->tax);
        }

        $taxableAmount = ($item->price ?? 0) * ($item->quantity ?? 0) - ($item->discount ?? 0);
        $itemTaxPrice = 0;
        $taxRates = [];
        $taxDetails = [];

        // Fetch tax details
        if (!empty($taxData)) {
            $uniqueTaxIds = array_unique(array_map('trim', $taxData));
            $taxes = \App\Models\Tax::whereIn('id', $uniqueTaxIds)->get();

            foreach ($taxes as $tax) {
                $rate = floatval($tax->rate);
                $taxRates[] = $rate;
                $taxDetails[] = $tax;
            }

            $totalRate = array_sum($taxRates);
            $totalTaxAmount = ($taxableAmount * $totalRate) / 100;
            $itemTaxPrice += $totalTaxAmount;
        }
    @endphp

    @if (!empty($taxDetails))
        @if (!empty($settings['tax_type']) && $settings['tax_type'] === 'VAT')
            <div>VAT ({{ $totalRate }}%) - {{ \Auth::user()->priceFormat($totalTaxAmount) }}</div>
            @php
                $taxSummary['VAT'] = ($taxSummary['VAT'] ?? 0) + $totalTaxAmount;
            @endphp
        @else
            @if ($isSameState)
                @php
                    $halfRate = $totalRate / 2;
                    $halfAmount = $totalTaxAmount / 2;

                    $taxSummary['CGST'] = ($taxSummary['CGST'] ?? 0) + $halfAmount;
                    $taxSummary['SGST'] = ($taxSummary['SGST'] ?? 0) + $halfAmount;
                @endphp
                <div>CGST ({{ $halfRate }}%) - {{ \Auth::user()->priceFormat($halfAmount) }}</div>
                <div>SGST ({{ $halfRate }}%) - {{ \Auth::user()->priceFormat($halfAmount) }}</div>
            @else
                @php
                    $taxSummary['IGST'] = ($taxSummary['IGST'] ?? 0) + $totalTaxAmount;
                @endphp
                <div>IGST ({{ $totalRate }}%) -{{ \Auth::user()->priceFormat($totalTaxAmount) }}</div>
            @endif
        @endif
    @else
        <div>—</div>
    @endif
</td>





                <td>{{ $item->description ?? '-' }}</td>
                <td class="text-end">
                    {{ \Auth::user()->priceFormat($taxableAmount + $itemTaxPrice) }}
                </td>
            </tr>
            @php
                $totalTaxPrice += $itemTaxPrice;
            @endphp
        @endforeach
    </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td></td>
                                                    <td><b>{{ __('Total') }}</b></td>
                                                    <td><b>{{ $totalQuantity }}</b></td>
                                                    <td><b>{{ \Auth::user()->priceFormat($totalPrice) }}</b></td>
                                                    <td><b>{{ \Auth::user()->priceFormat($totalDiscount) }}</b></td>
                                                    <td><b>{{ \Auth::user()->priceFormat($totalTaxPrice) }}</b></td>
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="text-end"><b>{{ __('Sub Total') }}</b></td>
                                                    <td class="text-end">{{ \Auth::user()->priceFormat($ewaybill->getSubTotal()) }}</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="text-end"><b>{{ __('Discount') }}</b></td>
                                                    <td class="text-end">{{ \Auth::user()->priceFormat($ewaybill->getTotalDiscount()) }}</td>
                                                </tr>
                                                @if (!empty($taxSummary))
                                                    @foreach ($taxSummary as $taxName => $taxPrice)
                                                        <tr>
                                                            <td colspan="6"></td>
                                                            <td class="text-end"><b>{{ $taxName }}</b></td>
                                                            <td class="text-end">{{ \Auth::user()->priceFormat($taxPrice) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="blue-text text-end"><b>{{ __('Total') }}</b></td>
                                                    <td class="blue-text text-end">{{ \Auth::user()->priceFormat($ewaybill->getTotal()) }}</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="text-end"><b>{{ __('Paid') }}</b></td>
                                                    <td class="text-end">{{ \Auth::user()->priceFormat($ewaybill->getTotal() - $ewaybill->getDue() - $ewaybill->ewaybillTotalCreditNote()) }}</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="text-end"><b>{{ __('Credit Note') }}</b></td>
                                                    <td class="text-end">{{ \Auth::user()->priceFormat($ewaybill->ewaybillTotalCreditNote()) }}</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="6"></td>
                                                    <td class="text-end"><b>{{ __('Due') }}</b></td>
                                                    <td class="text-end">{{ \Auth::user()->priceFormat($ewaybill->getDue()) }}</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        <div class="ewaybill-footer">
                                            <b>{{ $settings['footer_title'] ?? '' }}</b> <br>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <h5 class="d-inline-block">{{ __('Receipt Summary') }}</h5><br>
                    @if ($user_plan->storage_limit <= $ewaybill_user->storage_limit)
                        <small class="text-danger font-bold">{{ __('Your plan storage limit is over, so you cannot see customer-uploaded payment receipts.') }}</small><br>
                    @endif
                    <div class="table-responsive mt-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="text-dark">{{ __('Payment Receipt') }}</th>
                                    <th class="text-dark">{{ __('Date') }}</th>
                                    <th class="text-dark">{{ __('Amount') }}</th>
                                    <th class="text-dark">{{ __('Payment Type') }}</th>
                                    <th class="text-dark">{{ __('Account') }}</th>
                                    <th class="text-dark">{{ __('Reference') }}</th>
                                    <th class="text-dark">{{ __('Description') }}</th>
                                    <th class="text-dark">{{ __('Receipt') }}</th>
                                    <th class="text-dark">{{ __('OrderId') }}</th>
                                    @can('delete payment invoice')
                                        <th class="text-dark">{{ __('Action') }}</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                @if (!empty($ewaybill->payments) || !empty($ewaybill->bankPayments))
                                    @php
                                        $path = \App\Models\Utility::get_file('uploads/order');
                                    @endphp
                                    @foreach ($ewaybill->payments as $key => $payment)
                                        <tr>
                                            <td>
                                                @if (!empty($payment->add_receipt))
                                                    <a href="{{ asset(Storage::url('uploads/payment')) . '/' . $payment->add_receipt }}"
                                                       download="" class="btn btn-sm btn-secondary btn-icon" target="_blank">
                                                        <span class="btn-inner--icon"><i class="ti ti-download"></i></span>
                                                    </a>
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td>{{ \Auth::user()->dateFormat($payment->date) }}</td>
                                            <td>{{ \Auth::user()->priceFormat($payment->amount) }}</td>
                                            <td>{{ $payment->payment_type }}</td>
                                            <td>{{ !empty($payment->bankAccount) ? $payment->bankAccount->bank_name . ' ' . $payment->bankAccount->holder_name : '--' }}</td>
                                            <td>{{ !empty($payment->reference) ? $payment->reference : '--' }}</td>
                                            <td>{{ !empty($payment->description) ? $payment->description : '--' }}</td>
                                            @if ($user_plan->storage_limit <= $ewaybill_user->storage_limit)
                                                <td>--</td>
                                            @else
                                                <td>
                                                    @if (!empty($payment->receipt))
                                                        @if ($payment->payment_type == "STRIPE")
                                                            <a href="{{ $payment->receipt }}" target="_blank">
                                                                <i class="ti ti-file"></i>{{ __('Receipt') }}
                                                            </a>
                                                        @else
                                                            <a href="{{ $path . '/' . $payment->receipt }}" target="_blank">
                                                                <i class="ti ti-file"></i>{{ __('Receipt') }}
                                                            </a>
                                                        @endif
                                                    @elseif (!empty($payment->add_receipt))
                                                        <a href="{{ asset(Storage::url('Uploads/payment')) . '/' . $payment->add_receipt }}"
                                                           target="_blank">
                                                            <i class="ti ti-file"></i>{{ __('Receipt') }}
                                                        </a>
                                                    @else
                                                        --
                                                    @endif
                                                </td>
                                            @endif
                                            <td>{{ !empty($payment->order_id) ? $payment->order_id : '--' }}</td>
                                            @can('delete payment invoice')
                                                <td>
                                                    <div class="action-btn">
                                                        {!! Form::open([
                                                            'method' => 'post',
                                                            'route' => ['ewaybill.payment.destroy', $ewaybill->id, $payment->id],
                                                            'id' => 'delete-form-' . $payment->id,
                                                        ]) !!}
                                                        <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para bg-danger"
                                                           data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                           data-confirm="{{ __('Are You Sure?') . '|' . __('This action cannot be undone. Do you want to continue?') }}"
                                                           data-confirm-yes="document.getElementById('delete-form-{{ $payment->id }}').submit();">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                </td>
                                            @endcan
                                        </tr>
                                    @endforeach
                                    @foreach ($ewaybill->bankPayments as $key => $bankPayment)
                                        <tr>
                                            <td>-</td>
                                            <td>{{ \Auth::user()->dateFormat($bankPayment->date) }}</td>
                                            <td>{{ \Auth::user()->priceFormat($bankPayment->amount) }}</td>
                                            <td>{{ __('Bank Transfer') }}</td>
                                            <td>-</td>
                                            <td>-</td>
                                            <td>-</td>
                                            @if ($user_plan->storage_limit <= $ewaybill_user->storage_limit)
                                                <td>--</td>
                                            @else
                                                <td>
                                                    @if (!empty($bankPayment->receipt))
                                                        <a href="{{ $path . '/' . $bankPayment->receipt }}" target="_blank">
                                                            <i class="ti ti-file"></i>{{ __('Receipt') }}
                                                        </a>
                                                    @endif
                                                </td>
                                            @endif
                                            <td>{{ !empty($bankPayment->order_id) ? $bankPayment->order_id : '--' }}</td>
                                            @can('delete payment invoice')
                                                <td>
                                                    @if ($bankPayment->status == 'Pending')
                                                        <div class="action-btn me-2">
                                                            <a href="#"
                                                               data-url="{{ URL::to('ewaybill/' . $bankPayment->id . '/action') }}"
                                                               data-size="lg" data-ajax-popup="true"
                                                               data-title="{{ __('Payment Status') }}"
                                                               class="mx-3 btn btn-sm align-items-center bg-warning"
                                                               data-bs-toggle="tooltip" title="{{ __('Payment Status') }}">
                                                                <i class="ti ti-caret-right text-white"></i>
                                                            </a>
                                                        </div>
                                                    @endif
                                                    <div class="action-btn">
                                                        {!! Form::open([
                                                            'method' => 'post',
                                                            'route' => ['ewaybill.payment.destroy', $ewaybill->id, $bankPayment->id],
                                                            'id' => 'delete-form-' . $bankPayment->id,
                                                        ]) !!}
                                                        <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para bg-danger"
                                                           data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                           data-confirm="{{ __('Are You Sure?') . '|' . __('This action cannot be undone. Do you want to continue?') }}"
                                                           data-confirm-yes="document.getElementById('delete-form-{{ $bankPayment->id }}').submit();">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                </td>
                                            @endcan
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="{{ Gate::check('delete payment ewaybill') ? '10' : '9' }}" class="text-center text-dark">
                                            <p>{{ __('No Data Found') }}</p>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <h5 class="d-inline-block mb-5">{{ __('Credit Note Summary') }}</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="text-dark">{{ __('Date') }}</th>
                                    <th class="text-dark">{{ __('Amount') }}</th>
                                    <th class="text-dark">{{ __('Description') }}</th>
                                    @if (Gate::check('edit credit note') || Gate::check('delete credit note'))
                                        <th class="text-dark">{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($ewaybill->creditNote as $key => $creditNote)
                                    <tr>
                                        <td>{{ \Auth::user()->dateFormat($creditNote->date) }}</td>
                                        <td>{{ \Auth::user()->priceFormat($creditNote->amount) }}</td>
                                        <td>{{ $creditNote->description ?? '-' }}</td>
                                        <td>
                                            @can('edit credit note')
                                                <div class="action-btn me-2">
                                                    <a data-url="{{ route('ewaybill.edit.credit.notes', [$creditNote->ewaybill, $creditNote->id]) }}"
                                                       data-ajax-popup="true" title="{{ __('Edit Credit Note') }}"
                                                       class="mx-3 btn btn-sm align-items-center bg-info"
                                                       data-bs-toggle="tooltip" data-original-title="{{ __('Edit Credit Note') }}">
                                                        <i class="ti ti-pencil text-white"></i>
                                                    </a>
                                                </div>
                                            @endcan
                                            @can('delete credit note')
                                                <div class="action-btn">
                                                    {!! Form::open([
                                                        'method' => 'DELETE',
                                                        'route' => ['ewaybill.delete.credit.note', $creditNote->ewaybill, $creditNote->id],
                                                        'id' => 'delete-form-' . $creditNote->id,
                                                    ]) !!}
                                                    <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para bg-danger"
                                                       data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                       data-confirm="{{ __('Are You Sure?') . '|' . __('This action cannot be undone. Do you want to continue?') }}"
                                                       data-confirm-yes="document.getElementById('delete-form-{{ $creditNote->id }}').submit();">
                                                        <i class="ti ti-trash text-white"></i>
                                                    </a>
                                                    {!! Form::close() !!}
                                                </div>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="{{ Gate::check('edit credit note') || Gate::check('delete credit note') ? '4' : '3' }}" class="text-center">
                                            <p class="text-dark">{{ __('No Data Found') }}</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection