<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\AttendanceEmployee;
use App\Models\PaySlip;
use App\Models\Allowance;
use App\Models\AllowanceOption;
use App\Models\Commission;
use App\Models\DeductionOption;
use App\Models\Employee;
use App\Models\Loan;
use App\Models\LoanOption;
use App\Models\OtherPayment;
use App\Models\BankAccount;
use App\Models\Overtime;
use App\Models\PayslipType;
use App\Models\SaturationDeduction;
use Illuminate\Http\Request;

class SetSalaryController extends Controller
{
public function index()
{
if(\Auth::user()->can('manage set salary'))
{
$employees = Employee::where('created_by' , \Auth::user()->creatorId())->with('salaryType')->get();

return view('setsalary.index', compact('employees'));
}
else
{
return redirect()->back()->with('error', __('Permission denied.'));
}
}

public function edit($id)
{
if(\Auth::user()->can('edit set salary'))
{
$payslip_type= PayslipType::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$allowance_options = AllowanceOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$loan_options= LoanOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$deduction_options = DeductionOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
if(\Auth::user()->type == 'Employee')
{
$currentEmployee= Employee::where('user_id', '=', \Auth::user()->id)->first();
$allowances = Allowance::where('employee_id', $currentEmployee->id)->get();
$commissions= Commission::where('employee_id', $currentEmployee->id)->get();
$loans= Loan::where('employee_id', $currentEmployee->id)->get();
$saturationdeductions = SaturationDeduction::where('employee_id', $currentEmployee->id)->get();
$otherpayments= OtherPayment::where('employee_id', $currentEmployee->id)->get();
$overtimes= Overtime::where('employee_id', $currentEmployee->id)->get();
$employee = Employee::where('user_id', '=', \Auth::user()->id)->first();
return view('setsalary.employee_salary', compact('employee', 'payslip_type', 'allowance_options', 'commissions', 'loan_options', 'overtimes', 'otherpayments', 'saturationdeductions', 'loans', 'deduction_options', 'allowances'));
}
else
{
$allowances = Allowance::where('employee_id', $id)->get();
$commissions= Commission::where('employee_id', $id)->get();
$loans= Loan::where('employee_id', $id)->get();
$saturationdeductions = SaturationDeduction::where('employee_id', $id)->get();
$otherpayments= OtherPayment::where('employee_id', $id)->get();
$overtimes= Overtime::where('employee_id', $id)->get();
$employee = Employee::find($id);

return view('setsalary.edit', compact('employee', 'payslip_type', 'allowance_options', 'commissions', 'loan_options', 'overtimes', 'otherpayments', 'saturationdeductions', 'loans', 'deduction_options', 'allowances'));
}
}
else
{
return redirect()->back()->with('error', __('Permission denied.'));
}
}

public function show($id)
{
$payslip_type= PayslipType::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$allowance_options = AllowanceOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$loan_options= LoanOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$deduction_options = DeductionOption::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
if(\Auth::user()->type == 'Employee')
{
$currentEmployee= Employee::where('user_id', '=', \Auth::user()->id)->first();
$allowances = Allowance::where('employee_id', $currentEmployee->id)->with(['employee','allowanceOption'])->get();
$commissions= Commission::where('employee_id', $currentEmployee->id)->with(['employee'])->get();
$loans= Loan::where('employee_id', $currentEmployee->id)->With(['employee','loanOption'])->get();
$saturationdeductions = SaturationDeduction::where('employee_id', $currentEmployee->id)->with(['deductionOption'])->get();
$otherpayments= OtherPayment::where('employee_id', $currentEmployee->id)->get();
$overtimes= Overtime::where('employee_id', $currentEmployee->id)->get();
$employee = Employee::where('user_id', '=', \Auth::user()->id)->with('salaryType')->first();

foreach ( $allowances as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $commissions as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $loans as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $saturationdeductions as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $otherpayments as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

return view('setsalary.employee_salary', compact('employee', 'payslip_type', 'allowance_options', 'commissions', 'loan_options', 'overtimes', 'otherpayments', 'saturationdeductions', 'loans', 'deduction_options', 'allowances'));


}
else
{
$allowances = Allowance::where('employee_id', $id)->get();
$commissions= Commission::where('employee_id', $id)->get();
$loans= Loan::where('employee_id', $id)->get();
$saturationdeductions = SaturationDeduction::where('employee_id', $id)->get();
$otherpayments= OtherPayment::where('employee_id', $id)->get();
$overtimes= Overtime::where('employee_id', $id)->get();
$employee = Employee::with('salaryType')->find($id);

foreach ( $allowances as$value) {

if($value->type == 'percentage' )
{
$employee= Employee::with('salaryType')->find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $commissions as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::with('salaryType')->find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $loans as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::with('salaryType')->find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $saturationdeductions as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::with('salaryType')->find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

foreach ( $otherpayments as$value) {
if($value->type == 'percentage' )
{
$employee= Employee::with('salaryType')->find($value->employee_id);
$empsal= $value->amount * $employee->salary / 100;
$value->tota_allow = $empsal;
}
}

return view('setsalary.employee_salary', compact('employee', 'payslip_type', 'allowance_options', 'commissions', 'loan_options', 'overtimes', 'otherpayments', 'saturationdeductions', 'loans', 'deduction_options', 'allowances'));
}

}

public function employeeUpdateSalary(Request $request, $id)
{
    $Allowancetypes = Allowance::$Allowancetype;

    $validator = \Validator::make($request->all(), [
        'salary_type' => 'required|exists:payslip_types,id',
        'salary' => 'required|numeric',
        'account' => 'required|exists:bank_accounts,id',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->with('error', $validator->errors()->first());
    }

    $employee = Employee::findOrFail($id);
    $created_by = \Auth::user()->creatorId();

    $annualCTC = $request->salary;
    $monthlySalary = $annualCTC / 12;
    $payslipType = PayslipType::find($request->salary_type);

    
    $employee->salary_type = $request->salary_type;
    $employee->salary = $annualCTC;
    $employee->account = $request->account;
    $employee->save();

    
    Allowance::where('employee_id', $id)->delete();
    SaturationDeduction::where('employee_id', $id)->delete();

    $companyDoj = Carbon::parse($employee->company_doj);
    $month = $request->month ?? Carbon::now()->month;
    $year = $request->year ?? Carbon::now()->year;

    $startDate = Carbon::create($year, $month, 1);
    $endDate = Carbon::create($year, $month)->endOfMonth();
    $daysInMonth = $startDate->daysInMonth;

   
    $attendanceDates = \DB::table('attendance_employees')
        ->where('employee_id', $employee->id)
        ->whereMonth('date', $month)
        ->whereYear('date', $year)
        ->pluck('date')
        ->map(function ($date) {
            return Carbon::parse($date)->format('Y-m-d');
        })->toArray();

  
    $period = CarbonPeriod::create($startDate, $endDate);
    $lopDaysAttendance = 0;
    $working_days = 0;

    foreach ($period as $date) {
        $formatted = $date->format('Y-m-d');

        if (!in_array($formatted, $attendanceDates)) {
            $lopDaysAttendance++;
        } else {
            $working_days++;
        }
    }

    
    $allowanceOptions = [
        'Basic' => 48.25,
        'HRA' => 19.97,
        'Conveyance' => 5.99,
        'Medical Allowance' => 4.16,
        'LTA' => 21.63,
    ];

    foreach ($allowanceOptions as $title => $percent) {
        $option = AllowanceOption::firstOrCreate(['name' => $title]);

        $amount = ($monthlySalary * $percent) / 100;
        $actualAmount = ($daysInMonth > 0) ? ($amount / $daysInMonth * $working_days) : 0;

        $type = isset($Allowancetypes['fixed']) && is_string($Allowancetypes['fixed']) 
            ? $Allowancetypes['fixed'] 
            : 'fixed';

        Allowance::create([
            'employee_id' => $id,
            'allowance_option' => $option->id,
            'title' => $title,
            'type' => $type,
            'basic_salary' => $monthlySalary,
            'amount' => $amount,
            'actual_amount' => $actualAmount,
            'created_by' => $created_by,
        ]);
    }

    // === LOP Calculation Start (based on attendance, events, leaves, and grace logic) ===
    $now = Carbon::create($year, $month, 1);
    $startOfMonth = $now->copy()->startOfMonth();
    $endOfMonth = $now->copy()->endOfMonth();
    $daysInMonth = $startOfMonth->daysInMonth;

    $lopDays = 0;
    $graceUsed = 0;
    $effectiveWorkingDays = 0;

    $previousMonth = $now->copy()->subMonth();
    $previousGraceCount = \DB::table('leaves')
        ->where('employee_id', $id)
        ->whereMonth('start_date', $previousMonth->month)
        ->whereYear('start_date', $previousMonth->year)
        ->where('status', 'Approved')
        ->count();

    for ($day = 1; $day <= $daysInMonth; $day++) {
        $date = Carbon::create($year, $month, $day);
        if ($date->lt($companyDoj)) {
            continue;
        }

        $dateString = $date->toDateString();

        $hasAttendance = AttendanceEmployee::where('employee_id', $id)
            ->whereDate('date', $dateString)
            ->exists();

        $hasEvent = \DB::table('events')
            ->whereDate('start_date', '<=', $dateString)
            ->whereDate('end_date', '>=', $dateString)
            ->exists();

        if ($hasAttendance || $hasEvent) {
            $effectiveWorkingDays++;
            continue;
        }

        $isLeaveApproved = \DB::table('leaves')
            ->where('employee_id', $id)
            ->where('status', 'Approved')
            ->whereDate('start_date', '<=', $dateString)
            ->whereDate('end_date', '>=', $dateString)
            ->exists();

        if ($isLeaveApproved) {
            $allowedGrace = $previousGraceCount == 0 ? 2 : 1;

            if ($graceUsed < $allowedGrace) {
                $graceUsed++;
            } else {
                $lopDays++;
            }
        } else {
            $lopDays++;
        }
    }

    $perDaySalary = $monthlySalary / $daysInMonth;
    $lopAmount = $lopDays > 0 ? $lopDays * $perDaySalary : 0;

    $lopOption = DeductionOption::firstOrCreate(['name' => 'LOP']);
    SaturationDeduction::create([
        'employee_id' => $id,
        'deduction_option' => $lopOption->id,
        'title' => 'LOP',
        'type' => $Allowancetypes['fixed'],
        'amount' => $lopAmount,
        'created_by' => $created_by,
    ]);
   
    $deductions = [];

    if (stripos($payslipType->name, 'with pf') !== false) {
        $deductions['PF'] = 12;
        if ($monthlySalary * 12 <= 500000) {
            $deductions['ESI'] = 0.75;
        } else {
            $deductions['Income Tax'] = 18;
        }
        $deductions['Other'] = 5;
    } else {
        $deductions['Other'] = 5;
    }

    foreach ($deductions as $title => $percent) {
        $option = DeductionOption::firstOrCreate(['name' => $title]);

        SaturationDeduction::create([
            'employee_id' => $id,
            'deduction_option' => $option->id,
            'title' => $title,
            'type' => $Allowancetypes['fixed'],
            'amount' => ($monthlySalary * $percent) / 100,
            'created_by' => $created_by,
        ]);
    }

    return redirect()->back()->with('success', 'Employee salary updated successfully.');
}


public function employeeSalary()
{
if(\Auth::user()->type == "employee")
{
$employees = Employee::where('user_id', \Auth::user()->id)->get();
return view('setsalary.index', compact('employees'));
}
}

public function employeeBasicSalary($id)
{

$payslip_type = PayslipType::where('created_by', \Auth::user()->creatorId())->get()->pluck('name', 'id');
$account = BankAccount::where('created_by', \Auth::user()->creatorId())->where('holder_name' , '!=', 'cash')->get()->pluck('bank_name', 'id');

$employee = Employee::find($id);
return view('setsalary.basic_salary', compact('employee', 'payslip_type' , 'account'));
}
}
