<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Exports\PayslipExport;
use App\Models\Allowance;
use App\Models\Commission;
use App\Models\Employee;
use App\Models\Loan;
use App\Models\OtherPayment;
use App\Models\Overtime;
use App\Models\Resignation;
use App\Models\PaySlip;
use App\Models\SaturationDeduction;
use App\Models\Utility;
use App\Models\Termination;
use App\Models\User;
use App\Models\PayslipType;
use App\Models\AllowanceOption;
use App\Models\DeductionOption;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;

class PaySlipController extends Controller
{
public function index()
{
if(\Auth::user()->can('manage pay slip') || \Auth::user()->type != 'client' || \Auth::user()->type != 'company')
{
$employees = Employee::where(
[
'created_by' => \Auth::user()->creatorId(),
]
)->first();

$month = [
'01' => 'JAN',
'02' => 'FEB',
'03' => 'MAR',
'04' => 'APR',
'05' => 'MAY',
'06' => 'JUN',
'07' => 'JUL',
'08' => 'AUG',
'09' => 'SEP',
'10' => 'OCT',
'11' => 'NOV',
'12' => 'DEC',
];

$year = [
'2023' => '2023',
'2024' => '2024',
'2025' => '2025',
'2026' => '2026',
'2027' => '2027',
'2028' => '2028',
'2029' => '2029',
'2030' => '2030',
];

return view('payslip.index', compact('employees', 'month', 'year'));
}
else
{
return redirect()->back()->with('error', __('Permission denied.'));
}
}

public function create()
{
//
}

public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'month' => 'required',
            'year' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $month = $request->month;
        $year = $request->year;
        $formate_month_year = $year . '-' . $month;

        $startDate = Carbon::createFromDate($year, $month, 1);
        $endDate = $startDate->copy()->endOfMonth();
        $currentDate = Carbon::today();
        // If current month, use current date as end date
        $isCurrentMonth = ($year == $currentDate->year && $month == $currentDate->month);
        $calculationEndDate = $isCurrentMonth ? $currentDate : $endDate;
        $daysInMonth = $endDate->day;
        $effectiveDaysToCalculate = $isCurrentMonth ? $currentDate->day : $daysInMonth;
        $payslipType = PayslipType::find($request->salary_type);

        $existingPayslips = PaySlip::where('salary_month', $formate_month_year)
            ->where('created_by', \Auth::user()->creatorId())
            ->pluck('employee_id')
            ->toArray();

        $excludedEmployees = array_merge(
            Resignation::where('created_by', \Auth::user()->creatorId())
                ->where('resignation_date', '<=', now())
                ->pluck('employee_id')
                ->toArray(),
            Termination::where('created_by', \Auth::user()->creatorId())
                ->where('termination_date', '<=', now())
                ->pluck('employee_id')
                ->toArray()
        );

        $employees = Employee::where('created_by', \Auth::user()->creatorId())
            ->where('company_doj', '<=', $endDate->format('Y-m-d'))
            ->whereNotIn('id', $existingPayslips)
            ->whereNotIn('id', $excludedEmployees)
            ->where('salary', '>', 0)
            ->get();

        if ($employees->isEmpty()) {
            return redirect()->route('payslip.index')->with('error', __('Payslip already created or no eligible employees.'));
        }

        foreach ($employees as $employee) {
            $now = Carbon::create($year, $month, 1);
            $companyDoj = Carbon::parse($employee->company_doj);
            $employeeId = $employee->id;
            $effectiveWorkingDays = 0;
            $lopDays = 0;
            $graceUsed = 0;

            $previousGraceCount = \DB::table('leaves')
                ->where('employee_id', $employee->id)
                ->whereMonth('start_date', $now->subMonth()->month)
                ->whereYear('start_date', $now->year)
                ->where('status', 'Approved')
                ->count();

           

            for ($day = 1; $day <= $effectiveDaysToCalculate; $day++) {
                $date = Carbon::create($year, $month, $day);

                if ($date->lt($companyDoj)) continue;

                $dateString = $date->toDateString();

                $isPresent = \DB::table('attendance_employees')
                    ->where('employee_id', $employee->id)
                    ->whereDate('date', $dateString)
                    ->exists();

                $isEvent = \DB::table('events')
                    ->where('created_by', \Auth::user()->creatorId())
                    ->whereDate('start_date', '<=', $dateString)
                    ->whereDate('end_date', '>=', $dateString)
                    ->exists();

                if ($isPresent || $isEvent) {
                    $effectiveWorkingDays++;
                    continue;
                }

                $isLeaveApproved = \DB::table('leaves')
                    ->where('employee_id', $employee->id)
                    ->where('status', 'Approved')
                    ->whereDate('start_date', '<=', $dateString)
                    ->whereDate('end_date', '>=', $dateString)
                    ->exists();

                if ($companyDoj->month == $month && $companyDoj->year == $year) {
    $allowedGrace = 1;
} else {
    $allowedGrace = ($previousGraceCount == 0) ? 2 : 1;
}

                if ($isLeaveApproved) {
                    if ($graceUsed < $allowedGrace) {
                        $graceUsed++;
                    } else {
                        $lopDays++;
                    }
                } else {
                    $lopDays++;
                }
                

            }

          

            $basic_salary = $employee->salary ?? 0;
            $workingDays = $effectiveWorkingDays + $graceUsed;
            $monthlySalary = $employee->salary / 12;
            $perDaySalary = $monthlySalary / $daysInMonth;
            $lopDeduction = $lopDays * $perDaySalary;
            

            $allowances = [
                ['title' => 'Basic', 'percent' => 48.25],
                ['title' => 'HRA', 'percent' => 19.97],
                ['title' => 'Conveyance', 'percent' => 5.99],
                ['title' => 'Medical Allowance', 'percent' => 4.16],
                ['title' => 'LTA', 'percent' => 21.63],
            ];

            $allowanceData = [];
            $totalEarning = 0;
            foreach ($allowances as $index => $a) {
                $amount = round(($monthlySalary * $a['percent']) / 100, 2);
                $actualAmount = $daysInMonth > 0 ? ($amount / $daysInMonth * $workingDays) : 0;
                $totalEarning += $actualAmount;
                $allowanceData[] = [
                    'id' => null,
                    'employee_id' => $employee->id,
                    'allowance_option' => $index + 1,
                    'title' => $a['title'],
                    'amount' => $amount,
                    'type' => 'Fixed',
                    'created_by' => \Auth::user()->creatorId(),
                    'created_at' => now(),
                    'updated_at' => now(),
                    'basic_salary' => $employee->salary,
                    'actual_amount' => $actualAmount,
                ];
            }


foreach ($employees as $employee) {
    // Get salary type from employee record (e.g. 1 or 2)
    $payslipType = PayslipType::find($employee->salary_type);
    $typeName = strtolower(trim($payslipType->name ?? ''));

    $yearlySalary = $employee->salary; // Salary is yearly
    $monthlySalary = $yearlySalary / 12;

    $deductions = [];

    if (str_contains($typeName, 'with pf')) {
        $deductions['PF'] = 12;

        if ($yearlySalary <= 500000) {
            $deductions['ESI'] = 0.75;
        } else {
            $deductions['Income Tax'] = 18;
        }

        $deductions['Other'] = 5;
    } else {
        $deductions['Other'] = 5;
    }

}


            

            $deductionData = [];
            $totalDeduction = 0;
            foreach ($deductions as $title => $percent) {
                if ($percent > 0) {
                  $amount = round((($monthlySalary * $percent) / 100) / $daysInMonth * $effectiveDaysToCalculate, 2);

                    $totalDeduction += $amount;
                    $deductionData[] = [
                        'id' => null,
                        'employee_id' => $employee->id,
                        'allowance_option' => count($deductionData) + 1,
                        'title' => $title,
                        'amount' => $amount,
                        'type' => 'Fixed',
                        'created_by' => \Auth::user()->creatorId(),
                        'created_at' => now(),
                        'updated_at' => now(),
                        'basic_salary' => $employee->salary,
                    ];
                }
            }

            $lopData = [
                'id' => null,
                'employee_id' => $employee->id,
                'allowance_option' => count($deductionData) + 1,
                'title' => 'LOP',
                'amount' => $lopDeduction,
                'type' => 'Fixed',
                'created_by' => \Auth::user()->creatorId(),
                'created_at' => now(),
                'updated_at' => now(),
                'basic_salary' => $employee->salary,
            ];

            $deductionData[] = $lopData;
            $deduction = $totalDeduction + $lopDeduction;
            $net_salary = $totalEarning - $deduction;

        

            $payslip = new PaySlip();
            $payslip->employee_id = $employeeId;
            $payslip->salary_month = $formate_month_year;
            $payslip->net_payble = $net_salary < 0 ? 0 : round($net_salary);
            $payslip->status = 0;
            $payslip->basic_salary = $basic_salary;
            $payslip->allowance = json_encode($allowanceData);
            $payslip->commission = Employee::commission($employeeId);
            $payslip->loan = Employee::loan($employeeId);
            $payslip->saturation_deduction = json_encode($deductionData);
            $payslip->other_payment = Employee::other_payment($employeeId);
            $payslip->overtime = Employee::overtime($employeeId);
            $payslip->created_by = \Auth::user()->creatorId();
            $payslip->days_in_month = $effectiveDaysToCalculate;
            $payslip->lop = $lopDays;
            $payslip->working_days = $workingDays;
            $payslip->save();

            $settings = Utility::settings(\Auth::user()->creatorId());

            if (!empty($settings['payslip_notification'])) {
                Utility::send_slack_msg('new_monthly_payslip', ['year' => $formate_month_year]);
            }

            if (!empty($settings['telegram_payslip_notification'])) {
                Utility::send_telegram_msg('new_monthly_payslip', ['year' => $formate_month_year]);
            }

            $webhook = Utility::webhookSetting('New Monthly Payslip');
            if ($webhook) {
                Utility::WebhookCall($webhook['url'], json_encode($payslip), $webhook['method']);
            }
        }

        return redirect()->route('payslip.index')->with('success', __('Payslip successfully created.'));
    }

protected function m($number)
{
return number_format($number, 2);
}

public function destroy($id)
{
$payslip = PaySlip::find($id);
$payslip->delete();

return true;
}

public function showemployee($paySlip)
{
$payslip = PaySlip::find($paySlip);

return view('payslip.show', compact('payslip'));
}

public function search_json(Request $request)
{
$formate_month_year = $request->datePicker;
$validatePaysilp = PaySlip::where('salary_month', '=', $formate_month_year)->where('created_by', \Auth::user()->creatorId())->get()->toarray();

$data = [];
if (empty($validatePaysilp)) {
return response()->json(['data' => $data]);
} else {
$paylip_employee = PaySlip::select(
[
'employees.id',
'employees.employee_id',
'employees.name',
'payslip_types.name as payroll_type',
'pay_slips.basic_salary',
'pay_slips.net_payble',
'pay_slips.id as pay_slip_id',
'pay_slips.status',
'employees.user_id',
]
)->leftjoin(
'employees',
function ($join) use ($formate_month_year) {
$join->on('employees.id', '=', 'pay_slips.employee_id');
$join->on('pay_slips.salary_month', '=', \DB::raw("'" . $formate_month_year . "'"));
$join->leftjoin('payslip_types', 'payslip_types.id', '=', 'employees.salary_type');
}
)->where('employees.created_by', \Auth::user()->creatorId())->get();

$settings = Utility::settings();

foreach ($paylip_employee as $employee) {
if (Auth::user()->type == 'Employee') {
if (Auth::user()->id == $employee->user_id) {
$tmp = [];
$tmp[] = $employee->id;
$tmp[] = $employee->name;
$tmp[] = $employee->payroll_type;
$tmp[] = $employee->pay_slip_id;
$tmp[] = !empty($employee->basic_salary) ? \Auth::user()->priceFormat($employee->basic_salary) : '-';
$tmp[] = !empty($employee->net_payble) ? \Auth::user()->priceFormat($employee->net_payble) : '-';
$tmp[] = $employee->status == 1 ? 'paid' : 'unpaid';
$tmp[] = !empty($employee->pay_slip_id) ? $employee->pay_slip_id : 0;
$tmp['url'] = route('employee.show', Crypt::encrypt($employee->id));
$data[] = $tmp;
}
} else {
$tmp = [];
$prefix = isset($settings['employee_prefix']) ? ltrim($settings['employee_prefix'], '#') : 'EMP';
$cleanId = preg_replace('/\D/', '', $employee->employee_id);
$last5 = str_pad(substr($cleanId, -5), 5, '0', STR_PAD_LEFT);
$formattedId = $prefix . $last5;
$tmp[] = $employee->id;
$tmp[] = $formattedId;
$tmp[] = $employee->name;
$tmp[] = $employee->payroll_type;
$tmp[] = !empty($employee->basic_salary) ? \Auth::user()->priceFormat($employee->basic_salary) : '-';
$tmp[] = !empty($employee->net_payble) ? \Auth::user()->priceFormat($employee->net_payble) : '-';
$tmp[] = $employee->status == 1 ? 'Paid' : 'UnPaid';
$tmp[] = !empty($employee->pay_slip_id) ? $employee->pay_slip_id : 0;
$tmp['url'] = route('employee.show', Crypt::encrypt($employee->id));
$data[] = $tmp;
}
}

return $data;
}
}

public function paysalary($id, $date)
{
$employeePayslip = PaySlip::where('employee_id', '=', $id)->where('created_by', \Auth::user()->creatorId())->where('salary_month', '=', $date)->first();

$account = Employee::find($id);
Utility::bankAccountBalance($account->account, $employeePayslip->net_payble, 'debit');

if (!empty($employeePayslip)) {
$employeePayslip->status = 1;
$employeePayslip->save();

return redirect()->route('payslip.index')->with('success', __('Payslip Payment successfully.'));
} else {
return redirect()->route('payslip.index')->with('error', __('Payslip Payment failed.'));
}
}

public function bulk_pay_create($date)
{
$Employees = PaySlip::where('salary_month', $date)->where('created_by', \Auth::user()->creatorId())->get();
$unpaidEmployees = PaySlip::where('salary_month', $date)->where('created_by', \Auth::user()->creatorId())->where('status', '=', 0)->get();

return view('payslip.bulkcreate', compact('Employees', 'unpaidEmployees', 'date'));
}

public function bulkpayment(Request $request, $date)
{
$unpaidEmployees = PaySlip::where('salary_month', $date)->where('created_by', \Auth::user()->creatorId())->where('status', '=', 0)->get();

foreach ($unpaidEmployees as $employee) {
$employee->status = 1;
$employee->save();
}

return redirect()->route('payslip.index')->with('success', __('Payslip Bulk Payment successfully.'));
}

public function employeepayslip()
{
$employees = Employee::where(
[
'user_id' => \Auth::user()->id,
]
)->first();

$payslip = PaySlip::where('employee_id', '=', $employees->id)->get();

return view('payslip.employeepayslip', compact('payslip'));
}

public function pdf($id, $month)
{
$payslip = PaySlip::where('employee_id', $id)->where('salary_month', $month)->where('created_by', \Auth::user()->creatorId())->first();
$employee = Employee::find($payslip->employee_id);

$payslipDetail = Utility::employeePayslipDetail($id, $month);

return view('payslip.pdf', compact('payslip', 'employee', 'payslipDetail'));
}

public function send($id, $month)
{
$setings = Utility::settings();
if ($setings['payslip_sent'] == 1) {
$payslip = PaySlip::where('employee_id', $id)->where('salary_month', $month)->where('created_by', \Auth::user()->creatorId())->first();
$employee = Employee::find($payslip->employee_id);

$payslip->name = $employee->name;
$payslip->email = $employee->email;

$payslipId = Crypt::encrypt($payslip->id);
$payslip->url = route('payslip.payslipPdf', [$payslipId, $month]);

$payslipArr = [
'employee_name' => $employee->name,
'employee_email' => $employee->email,
'payslip_name' => $payslip->name,
'payslip_salary_month' => $payslip->salary_month,
'payslip_url' => $payslip->url,
];
$resp = Utility::sendEmailTemplate('payslip_sent', [$employee->id => $employee->email], $payslipArr);

if (!empty($employee->phone)) {
$number = preg_replace('/[^0-9]/', '', $employee->phone);
$message = "Dear {$employee->name}, your payslip of ({$payslip->salary_month}) is ready. Please check your email.";
$whatsappStatus = Utility::sendWhatsappMessage($number, $message);
}

return redirect()->back()->with('success', __('Payslip successfully sent.') . (($resp['is_success'] == false && !empty($resp['error'])) ? '<br> <span class="text-danger">' . $resp['error'] . '</span>' : ''));
}

return redirect()->back()->with('success', __('Payslip successfully sent.'));
}

public function payslipPdf($id, $month)
{
try {
$payslipId = Crypt::decrypt($id);
} catch (\Exception $e) {
return redirect()->back()->with('error', __('Something went wrong.'));
}

$payslip = PaySlip::where('id', $payslipId)->first();
$employee = Employee::find($payslip->employee_id);
$user = User::where('id', $employee->user_id)->first();

$payslipDetail = Utility::employeePayslipDetail($payslip->employee_id, $month);

return view('payslip.payslipPdf', compact('payslip', 'employee', 'payslipDetail', 'user'));
}

public function editEmployee($paySlip)
{
$payslip = PaySlip::find($paySlip);

return view('payslip.salaryEdit', compact('payslip'));
}

public function updateEmployee(Request $request, $id)
{
if (isset($request->allowance) && !empty($request->allowance)) {
$allowances = $request->allowance;
$allowanceIds = $request->allowance_id;
foreach ($allowances as $k => $allownace) {
$allowanceData = Allowance::find($allowanceIds[$k]);
$allowanceData->amount = $allownace;
$allowanceData->save();
}
}

if (isset($request->commission) && !empty($request->commission)) {
$commissions = $request->commission;
$commissionIds = $request->commission_id;
foreach ($commissions as $k => $commission) {
$commissionData = Commission::find($commissionIds[$k]);
$commissionData->amount = $commission;
$commissionData->save();
}
}

if (isset($request->loan) && !empty($request->loan)) {
$loans = $request->loan;
$loanIds = $request->loan_id;
foreach ($loans as $k => $loan) {
$loanData = Loan::find($loanIds[$k]);
$loanData->amount = $loan;
$loanData->save();
}
}

if (isset($request->saturation_deductions) && !empty($request->saturation_deductions)) {
$saturation_deductionss = $request->saturation_deductions;
$saturation_deductionsIds = $request->saturation_deductions_id;
foreach ($saturation_deductionss as $k => $saturation_deductions) {
$saturation_deductionsData = SaturationDeduction::find($saturation_deductionsIds[$k]);
$saturation_deductionsData->amount = $saturation_deductions;
$saturation_deductionsData->save();
}
}

if (isset($request->other_payment) && !empty($request->other_payment)) {
$other_payments = $request->other_payment;
$other_paymentIds = $request->other_payment_id;
foreach ($other_payments as $k => $other_payment) {
$other_paymentData = OtherPayment::find($other_paymentIds[$k]);
$other_paymentData->amount = $other_payment;
$other_paymentData->save();
}
}

if (isset($request->rate) && !empty($request->rate)) {
$rates = $request->rate;
$rateIds = $request->rate_id;
$hourses = $request->hours;

foreach ($rates as $k => $rate) {
$overtime = Overtime::find($rateIds[$k]);
$overtime->rate = $rate;
$overtime->hours = $hourses[$k];
$overtime->save();
}
}

$payslipEmployee = PaySlip::find($request->payslip_id);
$payslipEmployee->allowance = Employee::allowance($payslipEmployee->employee_id);
$payslipEmployee->commission = Employee::commission($payslipEmployee->employee_id);
$payslipEmployee->loan = Employee::loan($payslipEmployee->employee_id);
$payslipEmployee->saturation_deduction = Employee::saturation_deduction($payslipEmployee->employee_id);
$payslipEmployee->other_payment = Employee::other_payment($payslipEmployee->employee_id);
$payslipEmployee->overtime = Employee::overtime($payslipEmployee->employee_id);
$payslipEmployee->net_payble = Employee::find($payslipEmployee->employee_id)->get_net_salary();
$payslipEmployee->save();

return redirect()->route('payslip.index')->with('success', __('Employee payroll successfully updated.'));
}

public function export(Request $request)
{
$name = 'payslip_' . date('Y-m-d i:h:s');
$data = Excel::download(new PayslipExport($request), $name . '.xlsx');
ob_end_clean();
return $data;
}
}