@php
$logo = \App\Models\Utility::get_file('uploads/logo');
$company_favicon = Utility::companyData($user->created_by, 'company_favicon');
$setting = DB::table('settings')->where('created_by', $user->creatorId())->pluck('value', 'name')->toArray();
$settings_data = \App\Models\Utility::settingsById($user->created_by);
$color = !empty($setting['color']) ? $setting['color'] : 'theme-3';

if (isset($setting['color_flag']) && $setting['color_flag'] == 'true') {
$themeColor = 'custom-color';
} else {
$themeColor = $color;
}
$getseo = App\Models\Utility::getSeoSetting();
$metatitle = isset($getseo['meta_title']) ? $getseo['meta_title'] : '';
$metsdesc = isset($getseo['meta_desc']) ? $getseo['meta_desc'] : '';
$meta_image = \App\Models\Utility::get_file('uploads/meta/');
$meta_logo = isset($getseo['meta_image']) ? $getseo['meta_image'] : '';
$get_cookie = \App\Models\Utility::getCookieSetting();
$company_logo=Utility::getValByName('company_logo');
@endphp
@php
$addressParts = array_filter([
    $settings_data['company_address'] ?? '',
    $settings_data['company_city'] ?? '',
    $settings_data['company_state'] ?? '',
    $settings_data['company_zipcode'] ?? '',
]);
@endphp
@php
    $salaryMonthParts = explode('-', $payslip->salary_month);
    $year = $salaryMonthParts[0];
    $month = $salaryMonthParts[1];

    // Optional: Convert month number to name
    $monthNames = [
        '01' => 'January', '02' => 'February', '03' => 'March',
        '04' => 'April', '05' => 'May', '06' => 'June',
        '07' => 'July', '08' => 'August', '09' => 'September',
        '10' => 'October', '11' => 'November', '12' => 'December'
    ];
    $monthName = $monthNames[$month];
@endphp
<!DOCTYPE html>

<html lang="en" dir="{{ $settings_data['SITE_RTL'] == 'on' ? 'rtl' : '' }}">

<head>
<meta charset="UTF-8">
<meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
<title>{{ $settings_data['company_name']. ' - ' . __('Paylip') }}</title>

<meta name="title" content="{{ $metatitle }}">
<meta name="description" content="{{ $metsdesc }}">

<!-- Open Graph / Facebook -->
<meta property="og:type" content="website">
<meta property="og:url" content="{{ env('APP_URL') }}">
<meta property="og:title" content="{{ $metatitle }}">
<meta property="og:description" content="{{ $metsdesc }}">
<meta property="og:image" content="{{ $meta_image . $meta_logo }}">

<!-- Twitter -->
<meta property="twitter:card" content="summary_large_image">
<meta property="twitter:url" content="{{ env('APP_URL') }}">
<meta property="twitter:title" content="{{ $metatitle }}">
<meta property="twitter:description" content="{{ $metsdesc }}">
<meta property="twitter:image" content="{{ $meta_image . $meta_logo }}">

<link rel="icon"
href="{{ $logo . '/' . (isset($company_favicon) && !empty($company_favicon) ? $company_favicon : 'favicon.png') }}"
type="image" sizes="16x16">

<link rel="stylesheet" href="{{ asset('assets/css/plugins/main.css') }}">

<link rel="stylesheet" href="{{ asset('assets/css/plugins/style.css') }}">
<link rel="stylesheet" href="{{ asset('assets/css/plugins/animate.min.css') }}">


<!-- font css -->
<link rel="stylesheet" href="{{ asset('assets/fonts/tabler-icons.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/fonts/feather.css') }}">
<link rel="stylesheet" href="{{ asset('assets/fonts/fontawesome.css') }}">
<link rel="stylesheet" href="{{ asset('assets/fonts/material.css') }}">

<!-- vendor css -->
@if ($settings_data['SITE_RTL'] == 'on')
<link rel="stylesheet" href="{{ asset('assets/css/style-rtl.css') }}">
@endif
@if ($settings_data['cust_darklayout'] == 'on')
<link rel="stylesheet" href="{{ asset('assets/css/style-dark.css') }}" id="style">
@else
<link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" id="style">
@endif

<link rel="stylesheet" href="{{ asset('assets/css/customizer.css') }}">

<link rel="stylesheet" href="{{ asset('css/custom.css') }}" id="main-style-link">

<link rel="stylesheet" href="{{ asset('assets/css/plugins/bootstrap-switch-button.min.css') }}">

<style>
:root {
--color-customColor: <?=$color ?>;
}
</style>

<link rel="stylesheet" href="{{ asset('css/custom-color.css') }}">
@stack('css-page')

<meta name="csrf-token" content="{{ csrf_token() }}">
<style>
#card-element {
border: 1px solid #a3afbb !important;
border-radius: 10px !important;
padding: 10px !important;
}

</style>
</head>

<body class="{{ $themeColor }}">
<div class="container">
<div class="row">
<div class="col-12">
<div class="main-content">
<div class="text-md-right text-end my-3">
<a href="#" class="btn btn-warning" onclick="saveAsPDF()"><span class="fa fa-download"></span></a>
</div>
<div class="card invoice " id="printableArea">
<div class="card-body invoice-print">
<div class="invoice-title">
<h4 class="mb-4 fs-3">{{__('Payslip')}}</h4>
<div class="payslip-number">
<!-- <img src="{{$logo.'/'.(isset($company_logo) && !empty($company_logo)?$company_logo:'logo-dark.png')}}" width="170px;" alt=""> -->
 <p class="text-center fw-bold text-uppercase">{{ $settings_data['company_name'] ?? 'Company Name' }}</p>
 @if(empty($settings_data['company_name']))
        <p class="text-center text-danger text-uppercase fw-bold">Update company details from settings</p>
    @endif
<p class="text-center text-uppercase">{{ implode(' , ', $addressParts) }}</p>
</div>
</div>
<p class="text-center fw-bold">Payslip for the month of {{ $monthName }} {{ $year }}</p>
<div class="row">
<div class="col-md-6">
<ul class="list-unstyled mb-1">
<li class="mb-1"> <strong>{{__('Name')}} :</strong> {{$employee->name}}</li>
<li class="mb-1"><strong>{{ __('Join Date') }} :</strong> {{ \App\Models\Utility::formatDate($employee->company_doj) }}</li>
<li class="mb-1"> <strong>{{__('Location')}} :</strong> {{$employee->branch_location}}</li>
<li class="mb-1"><strong>{{__('Effective Working Days')}} :</strong>{{$payslip->working_days}}</li>
<li class="mb-1"><strong>{{__('Days In Month')}} :</strong> {{$payslip->days_in_month}}</li>
<li class="mb-1"> <strong>{{__('Pan No')}}:</strong>{{$employee->pan_number}}</li>
</ul>
</div>
<div class="col-md-6 text-md-right mb-0">
<ul class="list-unstyled mb-md-2 mb-0">
   <li><strong>{{__('PF UAN')}} :</strong> {{$employee->pf_number}}</li>
   <li><strong>{{__('ESI NO')}} :</strong> {{$employee->esi_number}}<br></li>
   <li><strong>{{__('LOP')}} :</strong> {{$payslip->lop}}<br></li>
   <li> <strong>{{__('Bank Details')}} :</strong>

{{ $employee->account_number }}<br>
{{ $employee->bank_identifier_code }}
{{ $employee->bank_name }} <br>



</ul>
</div>
</div>


<div class="row mt-2">
 <div class="col-md-12">
 <div class="card-body table-border-style">

@php
$allowances = json_decode($payslip->allowance ?? '[]');
$commissions = json_decode($payslip->commission ?? '[]');
$overtimes = json_decode($payslip->overtime ?? '[]');
$other_payments = json_decode($payslip->other_payment ?? '[]');
$deductions = json_decode($payslip->saturation_deduction ?? '[]');
$loans = json_decode($payslip->loan ?? '[]');

// Combine all earnings into one array
$all_earnings = [];
foreach ($allowances as $item) {
    $full = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $actual = $item->type == 'percentage' ? ($item->actual_amount * $payslip->basic_salary) / 100 : $item->actual_amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $full, 'actual' => $actual];
}
foreach ($commissions as $item) {
    $amount = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $amount, 'actual' => $amount];
}
foreach ($other_payments as $item) {
    $amount = $item->type == 'percentage' ? ($item->amount * $payslip->basic_salary) / 100 : $item->amount;
    $all_earnings[] = ['title' => $item->title, 'full' => $amount, 'actual' => $amount];
}
foreach ($overtimes as $ot) {
    $amount = ($ot->number_of_days ?? 0) * ($ot->hours ?? 0) * ($ot->rate ?? 0);
    $all_earnings[] = ['title' => $ot->title, 'full' => $amount, 'actual' => $amount];
}

// Combine all deductions into one array (excluding LOP with 0 amount)
$all_deductions = [];
foreach ($deductions as $deduct) {
    $amount = $deduct->type == 'percentage' ? ($deduct->amount * $payslip->basic_salary) / 100 : $deduct->amount;
    if ($amount > 0) {
        $all_deductions[] = ['title' => $deduct->title, 'amount' => $amount];
    }
}
foreach ($loans as $loan) {
    $amount = $loan->amount ?? 0;
    if ($amount > 0) {
        $all_deductions[] = ['title' => $loan->title ?? 'Loan', 'amount' => $amount];
    }
}

$totalFullEarning = 0;
$totalActualEarning = 0;
$totalDeduction = 0;

// Calculate totals for earnings
foreach ($all_earnings as $earning) {
    $totalFullEarning += $earning['full'];
    $totalActualEarning += $earning['actual'];
}

// Calculate total deductions
foreach ($all_deductions as $deduction) {
    $totalDeduction += $deduction['amount'];
}

// Determine the maximum number of rows needed
$maxRows = max(count($all_earnings), count($all_deductions));
@endphp

<div class="table-responsive">
<table class="table table-bordered mt-4">
<thead class="text-center custom-header">
<tr>
<th>{{__('Earning')}}</th>
<th>{{__('Full')}}</th>
<th>{{__('Actual')}}</th>
<th>{{__('Deduction')}}</th>
<th>{{__('Actual')}}</th>
</tr>
</thead>
<tbody>
    @for ($i = 0; $i < $maxRows; $i++)
    <tr>
        {{-- Earnings Column --}}
        @if ($i < count($all_earnings))
            @php
            $earning = $all_earnings[$i];
            @endphp
            <td>{{ $earning['title'] }}</td>
            <td>{{ \Auth::user()->priceFormat($earning['full']) }}</td>
            <td>{{ \Auth::user()->priceFormat($earning['actual']) }}</td>
        @else
            <td></td><td></td><td></td>
        @endif

        {{-- Deductions Column --}}
        @if ($i < count($all_deductions))
            @php
            $deduction = $all_deductions[$i];
            @endphp
            <td>{{ $deduction['title'] }}</td>
            <td>{{ \Auth::user()->priceFormat($deduction['amount']) }}</td>
        @else
            <td></td><td></td>
        @endif
    </tr>
    @endfor

    <tr class="fw-bold">
    <td>{{ __('Total Earnings') }}</td>
    <td>{{ \Auth::user()->priceFormat($totalFullEarning) }}</td>
    <td>{{ \Auth::user()->priceFormat($totalActualEarning) }}</td>
    <td>{{ __('Total Deduction') }}</td>
    <td>{{ \Auth::user()->priceFormat($totalDeduction) }}</td>
    </tr>
</tbody>
</table>
</div>

@php
$netSalary = round($payslip->net_payble);
$netPay = max(0, round($payslip->net_payble)); 
$fmt = new \NumberFormatter('en_IN', \NumberFormatter::SPELLOUT);
$inWords = ucfirst($fmt->format($netPay)) . ' rupees only';
@endphp

<p class="mt-3">
<span class="fw-bold">{{ __('Net Pay for the Month (Total Earning - Total Deduction):') }}</span>
<span>{{ \Auth::user()->priceFormat($netSalary) }}</span><br>
<span>( {{ $inWords }} )</span>
</p>

<p class="text-center text-muted small fst-italic">
{{ __('THIS IS A SYSTEM GENERATED PAYSLIP AND DOES NOT REQUIRE SIGNATURE') }}</p>

</div>
</div>

</div>
</div>
</div>

<footer id="footer-main">
<div class="footer-dark">
<div class="container">
<div class="row align-items-center justify-content-md-between py-4 mt-4 delimiter-top">
<div class="col-md-6">
<div class="copyright text-sm font-weight-bold text-center text-md-left">
{{ !empty($companySettings['footer_text']) ? $companySettings['footer_text']->value : '' }}
</div>
</div>
</div>
</div>
</div>
</footer>


<script src="{{ asset('js/jquery.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/popper.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/feather.min.js') }}"></script>
<script src="{{ asset('assets/js/dash.js') }}"></script>

<script src="{{ asset('assets/js/plugins/bootstrap-switch-button.min.js') }}"></script>

<script src="{{ asset('assets/js/plugins/sweetalert2.all.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/simple-datatables.js') }}"></script>

<!-- Apex Chart -->
<script src="{{ asset('assets/js/plugins/apexcharts.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/main.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>


<script src="{{ asset('js/jscolor.js') }}"></script>
<script src="{{ asset('js/custom.js') }}"></script>

@if ($message = Session::get('success'))
<script>
show_toastr('success', '{!! $message !!}');
</script>
@endif
@if ($message = Session::get('error'))
<script>
show_toastr('error', '{!! $message !!}');
</script>
@endif

@if ($get_cookie['enable_cookie'] == 'on')
@include('layouts.cookie_consent')
@endif

<script type="text/javascript" src="{{ asset('js/html2pdf.bundle.min.js') }}"></script>
<script>

function saveAsPDF() {
var element = document.getElementById('printableArea');
var opt = {
margin: 0.3,
filename: '{{$employee->name}}',
image: {type: 'jpeg', quality: 1},
html2canvas: {scale: 4, dpi: 72, letterRendering: true},
jsPDF: {unit: 'in', format: 'A4'}
};
html2pdf().set(opt).from(element).save();
}

// $(document).ready(function() {
// saveAsPDF();
// setTimeout(() => {
// window.close();
// }, 2000);
// });
</script>

</body>

</html>

