@php
    // Retrieve settings data
    $settings_data = \App\Models\Utility::settingsById($ewaybill->created_by);
    
    // Generate address parts
    $addressParts = array_filter([
        $settings_data['company_city'] ?? '',
        $settings_data['company_state'] ?? '',
        $settings_data['company_zipcode'] ?? '',
    ]);
  


    $logo = \App\Models\Utility::get_file('uploads/logo');
    $company_logo = \App\Models\Utility::GetLogo();

    // State comparison for tax calculation
    $companyState = strtolower(trim($settings_data['company_state'] ?? ''));
    $billingState = strtolower(trim($customer->billing_state ?? ''));
    $isSameState = !empty($companyState) && !empty($billingState) && $companyState === $billingState;
@endphp

@php
    $ewaybill_logo = Utility::getValByName('ewaybill_logo');
   
    $img = !empty($ewaybill_logo)
        ? asset('storage/ewaybill_logo/' . $ewaybill_logo)
        : asset('storage/uploads/logo/' . (!empty($company_logo) ? $company_logo : 'logo-dark.png'));
@endphp



<!DOCTYPE html>
<html lang="en" dir="{{ $settings_data['SITE_RTL'] == 'on' ? 'rtl' : '' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Lato:wght@300;400;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --theme-color: {{ $color }};
            --white: #ffffff;
            --black: #000000;
        }
        p { margin: 3px !important; }
        body {
            font-family: 'Lato', sans-serif;
            margin: 0;
            background: #f8f9fa;
        }
        .proposal-container {
            max-width: 800px;
            margin: 0 auto;
            background: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border: 1px solid black;
        }
        .company-info, .proposal-info {
            font-size: 14px;
        }
        .company-logo {
            max-width: 180px;
        }
        .info-table {
            width: 100%;
            margin-top: 20px;
        }
        .info-table td {
            vertical-align: top;
            padding: 10px 0;
        }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        .qrcode {
            max-width: 150px;
        }
        .dataTable th, .dataTable td {
            border-left: 1px solid black;
            border-right: 1px solid black;
        }
        .dataTable th {
            padding: 5px;
            border-top: 1px solid black;
            border-bottom: 1px solid black;
        }
        .amtTable td, .amtTable th {
            border-collapse: collapse;
            border-right: 1px solid black;
            border-bottom: 1px solid black;
        }
        .amtTable th {
            font-weight: normal;
        }
        .add-border{
 border: 1px solid var(--theme-color);
        }
         .invoice-footer {
            padding: 15px 20px;
        }
    </style>
    
</head>
<body>
<div class="proposal-container"  id="boxes">
    <div class="proposal-header" style="background: {{$color}};color:{{$fontColor}}">
        <div style="border-bottom: 1px solid black; text-align: center; padding:10px;">Tax Invoice</div>
        <div style="display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid black; padding: 10px 10px;">

       <div>
    <img src="{{ $img }}" alt="logo" width="200" />
</div>
       
            <div style="text-align: center;">
                <p style="text-transform: uppercase; font-size: 20px; font-weight: bold; color: #003580;">{{ $settings['company_name'] ?? '' }}</p>
                <p style="text-transform: uppercase; font-size: 15px; font-weight: bold;">{{ $settings_data['company_address'] ?? '' }}</p>
                <p style="text-transform: uppercase; font-size: 15px; font-weight: bold;">{{ implode(' , ', $addressParts) ?: '' }}</p>
                <p style="font-weight: bold;">{{ __('Tel:') }} {{ $settings['company_telephone'] ?? '' }}, {{ __('E-Mail:') }} {{ $settings['mail_from_address'] ?? '' }}</p>
                @if($settings['vat_gst_number_switch'] == 'on')
                    @if(!empty($settings['tax_type']) && !empty($settings['vat_number']))
                    <p style="font-weight: bold; text-align: center;">{{$settings['tax_type'].' '. __('Number')}} : {{$settings['vat_number']}} </p>
                        @endif
                       @endif
            </div>
            <div style="border: 1px solid black; padding: 3px;">
                @if ($settings['ewaybill_qr_display'] == 'on')
                    <div class="qrcode">
                        {!! DNS2D::getBarcodeHTML(route('ewaybill.link.copy', \Crypt::encrypt($ewaybill->id)), 'QRCODE', 2, 2) !!}
                    </div>
                @endif
            </div>
        </div>
    </div>
    <div class="proposal-body">
        <div style="border-bottom: 1px solid black; padding: 0 10px">
            <table>
                <tr><td>{{ __('IRN') }}</td><td>:</td><td><strong>{{ $ewaybill->irn ?? '' }}</strong></td></tr>
                <tr>
                    <td>{{ __('Ack No') }}</td><td>:</td><td><strong>{{ \App\Models\Utility::ebillNumberFormat($settings, $ewaybill->ewaybill_id) }}</strong></td>
                    <td style="padding-left: 150px;">{{ __('Ack Date') }}</td><td>:</td><td><strong>{{ \App\Models\Utility::dateFormat($settings, $ewaybill->issue_date) }}</strong></td>
                </tr>
            </table>
        </div>
    </div>
    <div style="border-bottom: 1px solid black; display: flex; justify-content: space-between; background-color: #e4e6fc; padding: 0 10px; font-weight: bold;">
        <p>{{ __('GSTIN/UIN:') }} {{ $customer->tax_number ?? '' }}</p>
        <p>{{ __('PAN NO:') }} {{ $settings_data['pan_number'] ?? '' }}</p>
    </div>
    <div style="padding: 0 10px; display: flex; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; flex: 1; box-sizing: border-box;">
            <strong style="margin-bottom: 10px;">{{ __('Buyer (Bill To)') }}</strong>
            @if (!empty($customer->billing_name))
                <p>
                    <span style="color: #003580; font-weight: bold;">{{ $customer->billing_name }}</span><br>
                    {{ $customer->billing_address ?? '' }}<br>
                    {{ $customer->billing_city ?? '' }},<br>
                    {{ __('State Name :') }} {{ $customer->billing_state ?? '' }}- {{ $customer->billing_zip ?? '' }}<br>
                  
                    {{ __('GSTIN NO:') }} {{ $customer->tax_number ?? '' }}
                </p>
            @else
                <p>-</p>
            @endif
        </div>
        @if ($settings['shipping_display'] == 'on')
            <div style="border-right: 1px solid black; flex: 1; box-sizing: border-box; padding: 0 10px;">
                <strong style="margin-bottom: 10px;">{{ __('Consignee (Ship To)') }}</strong>
                @if (!empty($customer->shipping_name))
                    <p>
                        <span style="color: #003580; font-weight: bold;">{{ $customer->shipping_name }}</span><br>
                        {{ $customer->shipping_address ?? '' }}<br>
                        {{ $customer->shipping_city ?? '' }},<br>
                        {{ __('State Name :') }} {{ $customer->shipping_state ?? '' }} - {{ $customer->billing_zip ?? '' }}<br>
                      
                        {{ __('GSTIN NO:') }} {{ $customer->tax_number ?? '' }}
                    </p>
                @else
                    <p>-</p>
                @endif
            </div>
        @endif
        <div style="flex: 1; box-sizing: border-box; padding: 0 10px;">
            <table>
                <!-- <tr><td>Invoice No</td><td>:</td><td></td></tr> -->
                <tr><td>Date</td><td>:</td><td>{{ \App\Models\Utility::dateFormat($settings, $ewaybill->due_date) }}</td></tr>
                <tr><td>E-way Bill No</td><td>:</td><td>{{ $ewaybill->converted_ewaybill_id ?? \App\Models\Utility::ebillNumberFormat($settings, $ewaybill->ewaybill_id) }}</td></tr>
                <tr><td>Delivery Distance</td><td>:</td><td>{{ $ewaybill->delivery_distance ?? '' }}</td></tr>
                <tr><td>Buyer Order No</td><td>:</td><td>{{ $ewaybill->buyer_order_no ?? '' }}</td></tr>
            </table>
        </div>
    </div>
    @php
    // Initialize totals
    $totalAmount = $totalCgst = $totalSgst = $totalIgst = $totalVat = $totalTax = 0;

    if (!empty($ewaybill->itemData)) {
        foreach ($ewaybill->itemData as $item) {
            // Calculate item total
            $itemTotal = ($item->price ?? 0) * ($item->quantity ?? 0) - ($item->discount ?? 0);
            $totalAmount += $itemTotal;

            if (!empty($item->itemTax) && is_array($item->itemTax)) {
                foreach ($item->itemTax as $tax) {
                    $taxPrice = floatval($tax['tax_price'] ?? 0);

                    if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat') {
                        // Handle VAT
                        if (strtolower($tax['name']) === 'vat') {
                            $totalVat += $taxPrice;
                            $totalTax += $taxPrice;
                        }
                    } else {
                        // Handle GST (CGST, SGST, IGST)
                        switch (strtoupper($tax['name'])) {
                            case 'CGST':
                                if ($isSameState) {
                                    $totalCgst += $taxPrice;
                                    $totalTax += $taxPrice;
                                }
                                break;
                            case 'SGST':
                                if ($isSameState) {
                                    $totalSgst += $taxPrice;
                                    $totalTax += $taxPrice;
                                }
                                break;
                            case 'IGST':
                                if (!$isSameState) {
                                    $totalIgst += $taxPrice;
                                    $totalTax += $taxPrice;
                                }
                                break;
                        }
                    }
                }
            }
        }
    }

    // Final rounding of totals
    $totalAmount = round($totalAmount, 2);
    $totalTax = round($totalTax, 2);

    $roundOff = round($totalAmount + $totalTax) - ($totalAmount + $totalTax);
    $grandTotal = $totalAmount + $totalTax + $roundOff;

    // Convert grand total to words
    $formatter = new \NumberFormatter('en_IN', \NumberFormatter::SPELLOUT);
    $grandTotalWords = ucfirst($formatter->format(floor($grandTotal))) . ' rupees';
    $decimalPart = round(($grandTotal - floor($grandTotal)) * 100);
    if ($decimalPart > 0) {
        $grandTotalWords .= ' and ' . $formatter->format($decimalPart) . ' paise';
    }
    $grandTotalWords .= ' only';
@endphp



 <table style="width: 100%; border-collapse: collapse;" class="dataTable add-border">
       <thead style="background: {{ $color }};color:{{ $fontColor }}">
        <tr>
           <th >{{ __('S.No') }}</th>
                <th style="width: 30%;">{{ __('Description') }}</th>
                <th style="width: 10%;">{{ __('HSN/SAC Code') }}</th>
                <th>{{ __('GST Rate') }}</th>
                <th>{{ __('Qty') }}</th>
                <th>{{ __('Unit') }}</th>
                <th>{{ __('(Incl)Rate') }}</th>
                <th>{{ __('Rate') }}</th>
                <th>{{ __('Disc') }}</th>
                <th>{{ __('Amount') }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($ewaybill->itemData as $index => $item)
            @php
                $itemTotal = ($item->price ?? 0) * ($item->quantity ?? 0) -  ($item->discount ?? 0);
                $unitDisplay = optional(\App\Models\ProductServiceUnit::find($item->unit))->name ?? '';
            @endphp
            <tr>
                 <td  style="text-align:center;">{{ $loop->iteration }}</td>
                <td  style="text-align:center;" >{{ $item->name ?? '' }}</td>
                <td  style="text-align:center;">{{ $item->expense_chartaccount_code  ?? '' }}</td>
               @php
    $groupedTaxes = [];
    foreach($item->itemTax as $tax) {
        $key = $tax['name'] . '|' . $tax['rate'];
        if (!isset($groupedTaxes[$key])) {
            $groupedTaxes[$key] = $tax;
            $groupedTaxes[$key]['price'] = floatval(str_replace(',', '', $tax['price']));
        } else {
            $groupedTaxes[$key]['price'] += floatval(str_replace(',', '', $tax['price']));
        }
    }
@endphp

<td  style="text-align:center; font-size:13px;" >
    @foreach($groupedTaxes as $tax)
        {{ $tax['name'] }} ({{ $tax['rate'] }})
    @endforeach
</td>
                <td style="font-weight: bold; text-align:center;">{{ $item->quantity ?? 0 }}</td>
                <td style="text-align:center;">{{ $unitDisplay }}</td>
                <td style="text-align:center;">{{ number_format($item->price ?? 0, 2) }}</td>
                <td style="text-align:center;">{{ number_format($item->price ?? 0, 2) }}</td>
                <td  style="text-align:center;">{{ $item->discount ? number_format($item->discount, 2) : '0' }}</td>
                <td style="font-weight: bold; text-align:center;">{{ number_format($itemTotal, 2) }}</td>
            </tr>
        @empty
            <tr><td colspan="10" class="text-center">No items found</td></tr>
        @endforelse
    </tbody>
   <tfoot style="border-top: 1px solid black; border-bottom: 1px solid black;">
            <tr>
                <td></td>
                <td style="text-align: center"><strong>{{ __('TOTAL') }}</strong></td>
                <td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                <td class="text-right" style="font-weight: bold;">{{ number_format($totalAmount, 2) }}</td>
            </tr>
        </tfoot>
</table>

@php
    $cgstRate = $sgstRate = $igstRate = $vatRate = 0;

    foreach ($ewaybill->itemData ?? [] as $item) {
        foreach ($item->itemTax ?? [] as $tax) {
            $rate = floatval(str_replace('%', '', $tax['rate'] ?? '0'));

            if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat') {
                // Handle VAT rate
                if (strtolower($tax['name']) === 'vat') {
                    $vatRate = $rate;
                }
            } else {
                // Handle GST rates (CGST, SGST, IGST)
                switch (strtoupper($tax['name'])) {
                    case 'CGST':
                        if ($isSameState) $cgstRate = $rate;
                        break;
                    case 'SGST':
                        if ($isSameState) $sgstRate = $rate;
                        break;
                    case 'IGST':
                        if (!$isSameState) $igstRate = $rate;
                        break;
                }
            }
        }
    }
@endphp


  <div style="display: flex; justify-content: space-between; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; width: 50%;">
            <div style="display: flex; width: 100%; border-bottom: 1px solid black;">
                <div style="width: 35%; padding: 10px; font-weight: normal;">Amount In Words:</div>
                <div style="width: 65%;  padding-bottom: 23px;">
                    <strong>{{ $grandTotalWords }}</strong>
                </div>
            </div>
            <div style="display: flex; padding: 10px; width: 100%;">
                <!-- <div style="width: 30%;">
                    @if ($settings['ewaybill_qr_display'] == 'on')
                    <div class="qrcode">
                        {!! DNS2D::getBarcodeHTML(route('ewaybill.link.copy', \Crypt::encrypt($ewaybill->id)), 'QRCODE', 2, 2) !!}
                    </div>
                @endif
                </div> -->
                <div style="width: 70%;">
                    <table>
                         @if ($invoicePayment && $invoicePayment->bankAccount)
    <tr>
        <td>Bank Name</td><td>:</td><td>{{ $invoicePayment->bankAccount->bank_name ?? '' }}</td>
    </tr>
    <tr>
        <td>Ac/No</td><td>:</td><td>{{ $invoicePayment->bankAccount->holder_name ?? '' }}</td>
    </tr>
    <tr>
        <td>Branch & IFS Code</td><td>:</td><td>{{ $invoicePayment->bankAccount->branch_name ?? '' }} {{ $invoicePayment->bankAccount->ifs_code ?? '' }}</td>
    </tr>
@else
    <tr><td colspan="3">No bank details available.</td></tr>
@endif
                    </table>
                </div>
            </div>
        </div>

    <div style="width: 50%;">
        <table class="amtTable">
            <tr><td style="width: 25%; font-weight: bold;">Basic Amount</td><td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($totalAmount, 2) }}</td></tr>
            @if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat')
    @if ($totalVat > 0)
        <tr>
            <td style="width: 25%; font-weight: bold;">VAT</td>
            <td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($totalVat, 2) }}</td>
        </tr>
    @endif
@else
    @if ($isSameState)
        <tr>
            <td style="width: 25%; font-weight: bold;">CGST</td>
            <td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($totalCgst, 2) }}</td>
        </tr>
        <tr>
            <td style="width: 25%; font-weight: bold;">SGST</td>
            <td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($totalSgst, 2) }}</td>
        </tr>
    @elseif ($totalIgst > 0)
        <tr>
            <td style="width: 25%; font-weight: bold;">IGST</td>
            <td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($totalIgst, 2) }}</td>
        </tr>
    @endif
@endif
            <tr><td style="width: 25%; font-weight: bold;">Round Off</td><td class="text-right" style="width: 25%; font-weight: bold;">{{ number_format($roundOff, 2) }}</td></tr>
            <tr><td style="width: 25%; font-weight: bold;"><strong>Grand Total</strong></td><td class="text-right" style="width: 25%; font-weight: bold;"><strong>{{ number_format($grandTotal, 2) }}</strong></td></tr>
           <tr>
    <td style="width: 25%; font-weight: bold;"><b>{{ __('Paid') }}</b></td>
    <td class="text-right" style="width: 25%; font-weight: bold;">
        {{ number_format($ewaybill->getTotal() - $ewaybill->getDue() - $ewaybill->ewaybillTotalCreditNote(), 2) }}
    </td>
</tr>
<tr>
    <td style="width: 25%; font-weight: bold;"><b>{{ __('Credit Note') }}</b></td>
    <td class="text-right" style="width: 25%; font-weight: bold;">
        {{ number_format($ewaybill->ewaybillTotalCreditNote(), 2) }}
    </td>
</tr>
<tr>
    <td style="width: 25%; font-weight: bold;"><b>{{ __('Due') }}</b></td>
    <td class="text-right" style="width: 25%; font-weight: bold;">
        {{ number_format($ewaybill->getDue(), 2) }}
    </td>
</tr>
        </table>

    </div>
</div>
<table class="amtTable" style="width: 100%;">
    <thead>
        <tr>
            <th rowspan="2" style="width: 470px;" class="text-right">Taxable Value</th>
            @if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat')
        <th colspan="2">VAT</th>
    @elseif ($isSameState)
        <th colspan="2">CGST</th>
        <th colspan="2">SGST</th>
    @elseif ($totalIgst > 0)
        <th colspan="2">IGST</th>
    @endif
            <th rowspan="2">Total Tax Amount</th>
        </tr>
        <tr>
        @if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat')
        <th>Rate</th><th>Amount</th>
    @elseif ($isSameState)
        <th>Rate</th><th>Amount</th>
        <th>Rate</th><th>Amount</th>
    @elseif ($totalIgst > 0)
        <th>Rate</th><th>Amount</th>
    @endif
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="text-right">{{ number_format($totalAmount, 2) }}</td>
            @if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat')
    <td style="text-align: center">{{ number_format($vatRate, 2) }}%</td>
    <td class="text-right">{{ number_format($totalVat, 2) }}</td>
@elseif ($isSameState)
    <td style="text-align: center">{{ number_format($cgstRate, 2) }}%</td>
    <td class="text-right">{{ number_format($totalCgst, 2) }}</td>
    <td style="text-align: center">{{ number_format($sgstRate, 2) }}%</td>
    <td class="text-right">{{ number_format($totalSgst, 2) }}</td>
@elseif ($totalIgst > 0)
    <td style="text-align: center">{{ number_format($igstRate, 2) }}%</td>
    <td class="text-right">{{ number_format($totalIgst, 2) }}</td>
@endif
            <td class="text-right">{{ number_format($totalTax, 2) }}</td>
        </tr>
    </tbody>
  <tfoot style="border-bottom: 1px solid black;">
        <tr>
            <td class="text-right" style="font-weight: bold;">Total: {{ number_format($totalAmount, 2) }}</td>
            @if (!empty($settings['tax_type']) && strtolower($settings['tax_type']) === 'vat')
    <td></td>
    <td class="text-right" style="font-weight: bold;">{{ number_format($totalVat, 2) }}</td>
@elseif ($isSameState)
    <td></td>
    <td class="text-right" style="font-weight: bold;">{{ number_format($totalCgst, 2) }}</td>
    <td></td>
    <td class="text-right" style="font-weight: bold;">{{ number_format($totalSgst, 2) }}</td>
@elseif ($totalIgst > 0)
    <td></td>
    <td class="text-right" style="font-weight: bold;">{{ number_format($totalIgst, 2) }}</td>
@endif

            <td class="text-right" style="font-weight: bold;">{{ number_format($totalTax, 2) }}</td>
        </tr>
    </tfoot>
</table>



<div style="display: flex; justify-content: space-between; border-bottom: 1px solid black;">
        <div style="border-right: 1px solid black; width: 50%; padding: 10px;">
    <p><strong>Terms & Conditions:</strong></p>
    <ul>
        <li>Goods once sold will not be taken back.</li>
        <li>
            Interest @10%
            <!-- @if ($isSameState)
                {{ number_format($cgstRate + $sgstRate, 2) }}%
            @elseif ($totalIgst > 0)
                {{ number_format($igstRate, 2) }}%
            @else
                0%
            @endif -->
            p.a. will be charged if the payment is not made within the stipulated time.
        </li>
        <li>We declare that this invoice shows the actual price and that all particulars are true and correct.</li>
    </ul>
</div>

        <div style="width: 50%; display: flex; flex-direction: column; align-items: flex-end; padding: 0 10px;">
            <p style="font-weight: bold;">For {{ $settings['company_name'] ?? '' }}</p>
            
            <p style="font-weight: bold; padding-top:130px;">Authorized Signatory</p>
        </div>
    </div>
</div>
<div style="text-align: center">
    <p>SUBJECT TO {{ strtoupper($settings['company_state'] ?? 'YOUR STATE') }} JURISDICTION</p>
    <p>This is a Computer Generated Invoice</p>
</div>
<div class="invoice-footer" style="text-align: center">
            <b>{{$settings['footer_title']}}</b> <br>
            {!! $settings['footer_notes'] !!}
</div>
@if (!isset($preview))
    @include('ewaybill.script')
@endif
</body>
</html>