@extends('layouts.admin')
@section('page-title')
{{ __('Edit Employee') }}
@endsection
@section('breadcrumb')
<li class="breadcrumb-item">
<a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
</li>
<li class="breadcrumb-item"><a href="{{ route('employee.index') }}">{{ __('Employee') }}</a></li>
<li class="breadcrumb-item">{{ $employeesId }}</li>
@endsection


@section('content')
<div class="row">
{{ Form::model($employee, ['route' => ['employee.update', $employee->id], 'method' => 'PUT', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
<div class="col-md-6 ">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Personal Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">

<div class="row">
<div class="form-group col-md-6">
{!! Form::label('name', __('Name'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::text('name', null, [
'class' => 'form-control',
'required' => 'required',
'placeholder' => __('Enter employee name'),
]) !!}
</div>
<div class="col-md-6">
<x-mobile label="{{ __('Phone') }}" name="phone" value="{{ $employee->phone }}" required
placeholdeer="Enter employee phone"></x-mobile>

</div>
<div class="form-group col-md-6">

{!! Form::label('dob', __('Date of Birth'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::date('dob', null, ['class' => 'form-control', 'required' => 'required', 'max' => date('Y-m-d')]) !!}

</div>
<div class="form-group col-md-6">
{!! Form::label('gender', __('Gender'), ['class' => 'form-label']) !!}<x-required></x-required>
<div class="d-flex radio-check">
<div class="form-check form-check-inline form-group">
<input type="radio" id="g_male" value="Male" name="gender"
class="form-check-input" {{ $employee->gender == 'Male' ? 'checked' : '' }}
required>
<label class="form-check-label" for="g_male">{{ __('Male') }}</label>
</div>
<div class="form-check form-check-inline form-group">
<input type="radio" id="g_female" value="Female" name="gender"
class="form-check-input" {{ $employee->gender == 'Female' ? 'checked' : '' }}
required>
<label class="form-check-label" for="g_female">{{ __('Female') }}</label>
</div>

</div>
</div>
<div class="form-group col-md-6">
{!! Form::label('aadhar_number', __('Aadhar Number'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::text('aadhar_number', null, [
'class' => 'form-control',
'required' => 'required',
'placeholder' => __('Enter Aadhar Number'),
]) !!}
</div>

<div class="form-group col-md-6">
{!! Form::label('pan_number', __('PAN Number'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::text('pan_number', null, [
'class' => 'form-control',
'required' => 'required',
'placeholder' => __('Enter PAN Number'),
]) !!}
</div>
</div>

<div class="form-group mb-0">
{!! Form::label('address', __('Address'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::textarea('address', null, [
'class' => 'form-control',
'rows' => 2,
'required' => 'required',
'placeholder' => __('Enter employee address'),
]) !!}
</div>
@if (\Auth::user()->type == 'employee')
{!! Form::submit('Update', ['class' => 'btn-create btn-xs badge-blue radius-10px float-right']) !!}
@endif
</div>
</div>
</div>

{{-- Start conditional block for editing --}}
@if(isset($employee) && \Auth::user()->can('edit employee'))
<div class="col-md-6 d-flex">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Company Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
<div class="row">
@csrf
<div class="form-group col-md-6">
{!! Form::label('employee_id', __('Employee ID'), ['class' => 'form-label']) !!}<x-required></x-required>

{!! Form::text('employee_id', old('employee_id', $formattedEmployeeId ?? null), [
'class' => 'form-control',
'placeholder' => __('Enter Employee ID'),
'required' => true,

]) !!}

@error('employee_id')
<span class="text-danger">{{ $message }}</span>
@enderror
</div>


<div class="form-group col-md-6">
{{ Form::label('role', __('Select Role'), ['class' => 'form-label']) }}
<x-required></x-required>
{{ Form::select('role', $roles, old('role', $selected_role_id), [
        'class' => 'form-control',
        'placeholder' => 'Select Role',
        'required' => true
    ]) }}
</div>


{{-- Reporting Manager --}}
<div class="form-group col-md-6">
{{ Form::label('reporting_manager', 'Reporting Manager') }}
<x-required></x-required>
{{ Form::select('reporting_manager', $reporting_managers, old('reporting_manager', $employee->reporting_manager ?? null), [
'class' => 'form-control',
'placeholder' => 'Select Reporting Manager',
'required' => true
]) }}
</div>

{{-- Team Lead --}}
<div class="form-group col-md-6">
{{ Form::label('team_lead', 'Team Lead') }}
<x-required></x-required>
{{ Form::select('team_lead', $team_leads, old('team_lead', $employee->team_lead ?? null), [
'class' => 'form-control',
'placeholder' => 'Select Team Lead',
'required' => true
]) }}
</div>


<div class="form-group col-md-6">
{{ Form::label('branch_id', __('Select Branch'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::select('branch_id', $branches, null, ['class' => 'form-control select', 'required' => 'required', 'id' => 'branch_id']) }}
<div class="text-xs mt-1">
{{ __('Create branch here.') }} <a href="{{ route('branch.index') }}"><b>{{ __('Create branch') }}</b></a>
</div>
</div>

<div class="form-group col-md-6">
{{ Form::label('department_id', __('Select Department'), ['class' => 'form-label']) }}<x-required></x-required>
<div class="form-icon-user">
{{ Form::select(
'department_id',
$departments,
old('department_id'), 
[
'class' => 'form-control',
'id' => 'department_id',
'placeholder' => 'Select Department',
'required' => 'required'
]
) }}
</div>
<div class="text-xs mt-1">
{{ __('Create department here.') }} <a href="{{ route('department.index') }}"><b>{{ __('Create department') }}</b></a>
</div>
</div>
<div class="form-group col-md-6">
{{ Form::label('designation_id', __('Select Designation'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::select('designation_id', $designations, null, ['class' => 'form-control select', 'required' => 'required', 'id' => 'designation_id']) }}
<div class="text-xs mt-1">
{{ __('Create designation here.') }} <a href="{{ route('designation.index') }}"><b>{{ __('Create designation') }}</b></a>
</div>
</div>

<div class="form-group col-md-6">
{!! Form::label('company_doj', 'Company Date Of Joining', ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::date('company_doj', null, ['class' => 'form-control ', 'required' => 'required']) !!}
</div>

<div class="form-group col-md-6">
{{ Form::label('pf_number', __('PF Number'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::text('pf_number', null, ['class' => 'form-control','required' => 'required', ]) }}
</div>

<div class="form-group col-md-6">
{{ Form::label('esi_number', __('ESI Number'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::text('esi_number', null, ['class' => 'form-control','required' => 'required', ]) }}
</div>
<div class="form-group col-md-6">
{{ Form::label('uan_number', __('UAN Number'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::text('uan_number', null, ['class' => 'form-control','required' => 'required', ]) }}
</div>
<div class="form-group col-md-6">
{{ Form::label('pran_number', __('PRAN Number'), ['class' => 'form-label']) }}<x-required></x-required>
{{ Form::text('pran_number', null, ['class' => 'form-control','required' => 'required',]) }}
</div>

</div>
</div>
</div>

@else

{{-- View-only section --}}
<div class="col-md-6 d-flex">
<div class="employee-detail-wrap">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Company Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
<div class="row">

<div class="form-group col-md-6">
<label for="role">{{ __('Select Role') }}</label>
<input type="text" class="form-control"value="{{ optional($employee->user?->roles)->pluck('name')->first() ?? '' }}" readonly>
</div>

<div class="form-group col-md-6">
<label for="reporting_manager">{{ __('Reporting Manager') }}</label>
<input type="text" name="reporting_manager" class="form-control" value="{{ old('reporting_manager', $employee->reporting_manager) }}" readonly>
</div>

<div class="form-group col-md-6">
<label for="team_lead">{{ __('Team Lead') }}</label>
<input type="text" name="team_lead" class="form-control" value="{{ old('team_lead', $employee->team_lead) }}" readonly>
</div>

<div class="col-md-6">
<div class="info">
<strong>{{ __('Branch') }}</strong>
<span>{{ !empty($employee->branch) ? $employee->branch->name : '' }}</span>
</div>
</div>

<div class="col-md-6">
<div class="info font-style">
<strong>{{ __('Department') }}</strong>
<span>{{ !empty($employee->department) ? $employee->department->name : '' }}</span>
</div>
</div>

<div class="col-md-6">
<div class="info font-style">
<strong>{{ __('Designation') }}</strong>
<span>{{ !empty($employee->designation) ? $employee->designation->name : '' }}</span>
</div>
</div>

<div class="col-md-6">
<div class="info">
<strong>{{ __('Date Of Joining') }}</strong>
<span>{{ \Auth::user()->dateFormat($employee->company_doj) }}</span>
</div>
</div>

<div class="form-group col-md-6">
<label for="uan_number">{{ __('UAN Number') }}</label>
<input type="text" name="uan_number" class="form-control" value="{{ $employee->uan_number }}" readonly>
</div>

<div class="form-group col-md-6">
<label for="pf_number">{{ __('PF Number') }}</label>
<input type="text" name="pf_number" class="form-control" value="{{ $employee->pf_number }}" readonly>
</div>

<div class="form-group col-md-6">
<label for="esi_number">{{ __('ESI Number') }}</label>
<input type="text" name="esi_number" class="form-control" value="{{ $employee->esi_number }}" readonly>
</div>

<div class="form-group col-md-6">
<label for="pran_number">{{ __('PRAN Number') }}</label>
<input type="text" name="pran_number" class="form-control" value="{{ $employee->pran_number }}" readonly>
</div>

</div>
</div>
</div>
</div>
</div>

@endif

</div>
@if (\Auth::user()->type != 'Employee')
<div class="row">
<div class="col-md-6 d-flex">
<div class="card emp_details w-100">
<div class="card-header">
<h6 class="mb-0">{{ __('Document') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
@php
$employeedoc = $employee->documents()->pluck('document_value', __('document_id'));
@endphp

@foreach ($documents as $key => $document)
<div class="row">
<div class="form-group col-12">
<div class="float-left col-4">
<label for="document" class="float-left pt-1 form-label">{{ $document->name }}
@if ($document->is_required == 1)
<x-required></x-required>
@endif
</label>
</div>
<div class="float-right col-4">
<input type="hidden" name="emp_doc_id[{{ $document->id }}]" id=""
value="{{ $document->id }}">
<div class="choose-file">
<label for="document[{{ $document->id }}]">
<input
class="form-control file-validate @if (!empty($employeedoc[$document->id])) float-left @endif @error('document') is-invalid @enderror "
@if ($document->is_required == 1 && empty($employeedoc[$document->id])) required @endif
name="document[{{ $document->id }}]"
onchange="document.getElementById('{{ 'blah' . $key }}').src = window.URL.createObjectURL(this.files[0])"
type="file" data-filename="{{ $document->id . '_filename' }}">
<p id="" class="file-error text-danger"></p>
</label>
<p class="{{ $document->id . '_filename' }}"></p>

@php
$logo = \App\Models\Utility::get_file('uploads/document/');
@endphp
<div class="choose-file-img">
<img id="{{ 'blah' . $key }}"
src="{{ isset($employeedoc[$document->id]) && !empty($employeedoc[$document->id]) ? $logo . '/' . $employeedoc[$document->id] : '' }}" />
</div>

</div>


</div>

</div>
</div>
@endforeach
</div>
</div>
</div>
<div class="col-md-6 d-flex">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Bank Account Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
<div class="row">
<div class="form-group col-md-6">
{!! Form::label('account_holder_name', __('Account Holder Name'), ['class' => 'form-label']) !!}
{!! Form::text('account_holder_name', null, [
'class' => 'form-control',
'placeholder' => __('Enter account holder name'),
]) !!}

</div>
<div class="form-group col-md-6">
{!! Form::label('account_number', __('Account Number'), ['class' => 'form-label']) !!}<x-required></x-required>
{!! Form::number('account_number', null, [
'class' => 'form-control',
'required' => 'required',
'placeholder' => __('Enter account number'),
]) !!}

</div>
<div class="form-group col-md-6">
{!! Form::label('bank_name', __('Bank Name'), ['class' => 'form-label']) !!}
{!! Form::text('bank_name', null, ['class' => 'form-control', 'placeholder' => __('Enter bank name')]) !!}

</div>
<div class="form-group col-md-6">
{!! Form::label('bank_identifier_code', __('Bank Identifier Code'), ['class' => 'form-label']) !!}
{!! Form::text('bank_identifier_code', null, [
'class' => 'form-control',
'placeholder' => __('Enter bank identifier code'),
]) !!}
</div>
<div class="form-group col-md-6">
{!! Form::label('branch_location', __('Branch Location'), ['class' => 'form-label']) !!}
{!! Form::text('branch_location', null, [
'class' => 'form-control',
'placeholder' => __('Enter branch location'),
]) !!}
</div>
<div class="form-group col-md-6">
{!! Form::label('tax_payer_id', __('Tax Payer Id'), ['class' => 'form-label']) !!}
{!! Form::text('tax_payer_id', null, ['class' => 'form-control', 'placeholder' => __('Enter tax payer id')]) !!}
</div>
</div>
</div>
</div>
</div>
</div>
@else
<div class="row">
<div class="col-md-6 d-flex">
<div class="employee-detail-wrap">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Document Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
<div class="row">
@php
$employeedoc = $employee
->documents()
->pluck('document_value', __('document_id'));
@endphp
@foreach ($documents as $key => $document)
<div class="col-md-12">
<div class="info">
<strong>{{ $document->name }}</strong>
<span><a href="{{ !empty($employeedoc[$document->id]) ? asset(Storage::url('uploads/document')) . '/' . $employeedoc[$document->id] : '' }}"
target="_blank">{{ !empty($employeedoc[$document->id]) ? $employeedoc[$document->id] : '' }}</a></span>
</div>
</div>
@endforeach
</div>
</div>
</div>
</div>
</div>
<div class="col-md-6 d-flex">
<div class="employee-detail-wrap">
<div class="card emp_details">
<div class="card-header">
<h6 class="mb-0">{{ __('Bank Account Detail') }}</h6>
</div>
<div class="card-body employee-detail-edit-body">
<div class="row">
<div class="col-md-6">
<div class="info">
<strong>{{ __('Account Holder Name') }}</strong>
<span>{{ $employee->account_holder_name }}</span>
</div>
</div>
<div class="col-md-6">
<div class="info font-style">
<strong>{{ __('Account Number') }}</strong>
<span>{{ $employee->account_number }}</span>
</div>
</div>
<div class="col-md-6">
<div class="info font-style">
<strong>{{ __('Bank Name') }}</strong>
<span>{{ $employee->bank_name }}</span>
</div>
</div>
<div class="col-md-6">
<div class="info">
<strong>{{ __('Bank Identifier Code') }}</strong>
<span>{{ $employee->bank_identifier_code }}</span>
</div>
</div>
<div class="col-md-6">
<div class="info">
<strong>{{ __('Branch Location') }}</strong>
<span>{{ $employee->branch_location }}</span>
</div>
</div>
<div class="col-md-6">
<div class="info">
<strong>{{ __('Tax Payer Id') }}</strong>
<span>{{ $employee->tax_payer_id }}</span>
</div>
</div>

</div>
</div>
</div>
</div>
</div>
</div>
@endif

@if (\Auth::user()->type != 'employee')
<div class="float-end">
<input type="button" value="{{ __('Cancel') }}"
onclick="location.href = '{{ route('employee.index') }}';" class="btn btn-secondary me-2">
<input type="submit" value="{{ __('Update') }}" class="btn btn-primary ">
</div>
@endif
{!! Form::close() !!}
</div>
@endsection

@push('script-page')
<script type="text/javascript">
$(document).on('change', '#branch_id', function() {
var branch_id = $(this).val();
getDepartment(branch_id);
});

function getDepartment(branch_id) {
var data = {
"branch_id": branch_id,
"_token": "{{ csrf_token() }}",
}

$.ajax({
url: '{{ route('employee.getdepartment') }}',
method: 'POST',
data: data,
success: function(data) {
$('#department_id').empty();
$('#department_id').append(
'<option value="" disabled>{{ __('Select Department') }}</option>');

$.each(data, function(key, value) {
$('#department_id').append('<option value="' + key + '">' + value +
'</option>');
});
$('#department_id').val('');
}
});
}
</script>
<script type="text/javascript">
function getDesignation(did) {
$.ajax({
url: '{{ route('employee.json') }}',
type: 'POST',
data: {
"department_id": did,
"_token": "{{ csrf_token() }}",
},
success: function(data) {
$('#designation_id').empty();
$('#designation_id').append('<option value="">Select Designation</option>');
$.each(data, function(key, value) {
var select = '';
if (key == '{{ $employee->designation_id }}') {
select = 'selected';
}

$('#designation_id').append('<option value="' + key + '"' + select + '>' +
value + '</option>');
});
}
});
}

$(document).ready(function() {
var d_id = $('#department_id').val();
var designation_id = '{{ $employee->designation_id }}';
getDesignation(d_id);
});

$(document).on('change', 'select[name=department_id]', function() {
var department_id = $(this).val();
getDesignation(department_id);
});
</script>
@endpush

