@extends('layouts.admin')
@section('page-title')
{{__('Dashboard')}}
@endsection
@push('script-page')
<script>
$(document).ready(function() {
get_data();
});

function get_data() {
var calender_type = $('#calender_type :selected').val();
$('#calendar').removeClass('local_calender goggle_calender');
if (calender_type == undefined) {
$('#calendar').addClass('local_calender');
}
$('#calendar').addClass(calender_type);
$.ajax({
url: $("#event_dashboard").val() + "/event/get_event_data",
method: "POST",
data: {"_token": "{{ csrf_token() }}", 'calender_type': calender_type},
success: function(data) {
(function() {
var calendar = new FullCalendar.Calendar(document.getElementById('calendar'), {
headerToolbar: {
left: 'prev,next today',
center: 'title',
right: 'timeGridDay,timeGridWeek,dayGridMonth'
},
buttonText: {
timeGridDay: "{{__('Day')}}",
timeGridWeek: "{{__('Week')}}",
dayGridMonth: "{{__('Month')}}"
},
slotLabelFormat: {
hour: '2-digit',
minute: '2-digit',
hour12: false,
},
themeSystem: 'bootstrap',
navLinks: true,
droppable: true,
selectable: true,
selectMirror: true,
editable: true,
dayMaxEvents: true,
handleWindowResize: true,
height: 'auto',
timeFormat: 'H(:mm)',
events: data,
locale: '{{basename(App::getLocale())}}',
dayClick: function(e) {
var t = moment(e).toISOString();
$("#new-event").modal("show");
$(".new-event--title").val("");
$(".new-event--start").val(t);
$(".new-event--end").val(t);
},
eventResize: function(event) {
var eventObj = {
start: event.start.format(),
end: event.end.format(),
};
},
viewRender: function(t) {
e.fullCalendar("getDate").month();
$(".fullcalendar-title").html(t.title);
},
eventClick: function(e, t) {
var title = e.title;
var url = e.url;
if (typeof url != 'undefined') {
$("#commonModal .modal-title").html(title);
$("#commonModal .modal-dialog").addClass('modal-md');
$("#commonModal").modal('show');
$.get(url, {}, function(data) {
$('#commonModal .modal-body').html(data);
});
return false;
}
}
});
calendar.render();
})();
}
});
}
</script>
@endpush
@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
<li class="breadcrumb-item">{{__('HRM')}}</li>
@endsection
@php
$setting = \App\Models\Utility::settings();
@endphp
@section('content')
@if(\Auth::user()->type != 'client' && \Auth::user()->type != 'company')
<div class="row">
<div class="col-sm-12">
<div class="row">
<div class="col-xxl-6">
<div class="card">
<div class="card-header">
<h5>{{__('Mark Attendance')}}</h5>
</div>
<div class="card-body dash-card-body">

<!-- Row 1: My Office Time aligned to top-left -->
<div class="row mb-3">
<div class="col-md-12 text-left">
<p class="mb-0">{{ __('My Office Time: ' . $officeTime['startTime'] . ' to ' . $officeTime['endTime']) }}</p>
</div>
</div>

<!-- Row 2: Work Mode centered -->
<div class="row justify-content-center mb-3">
<div class="form-group col-md-4 text-center">
<label class="d-block">
Work Mode <x-required />
</label>

{!! Form::select('work_mode', [
'Work from Home' => 'Work from Home',
'Work from Office' => 'Work from Office',
], old('work_mode', $attendance->work_mode ?? 'Work from Office'), [
'class' => 'form-control',
'required' => true,
'form' => 'clockInForm' // this stays as you had it
]) !!}
</div>
</div>

<!-- Row 3: Buttons centered side by side -->
<div class="row justify-content-center align-items-center">
<!-- CLOCK IN -->
<div class="col-md-3 text-center">
{{ Form::open(['url' => 'attendanceemployee/attendance', 'method' => 'post', 'id' => 'clockInForm']) }}
@if(empty($employeeAttendance) || $employeeAttendance->clock_out != '00:00:00')
<button type="submit" value="0" name="in" id="clock_in" class="btn btn-success w-100">{{ __('CLOCK IN') }}</button>
@else
<button type="submit" value="0" name="in" id="clock_in" class="btn btn-success disabled w-100" disabled>{{ __('CLOCK IN') }}</button>
@endif
{{ Form::close() }}
</div>

<!-- CLOCK OUT -->
<div class="col-md-3 text-center">
@if(!empty($employeeAttendance) && $employeeAttendance->clock_out == '00:00:00')
{{ Form::model($employeeAttendance, ['route' => ['attendanceemployee.update', $employeeAttendance->id], 'method' => 'PUT']) }}

{{-- Add visible work_mode dropdown to match Clock In --}}
{!! Form::select('work_mode', [
'Work from Home' => 'Work from Home',
'Work from Office' => 'Work from Office',
], $employeeAttendance->work_mode ?? 'Work from Office', [
'class' => 'form-control mb-2',
'required' => true
]) !!}

<button type="submit" value="1" name="out" id="clock_out" class="btn btn-danger w-100">{{ __('CLOCK OUT') }}</button>
{{ Form::close() }}
@else
<button type="submit" value="1" name="out" id="clock_out" class="btn btn-danger disabled w-100" disabled>{{ __('CLOCK OUT') }}</button>
@endif
</div>

</div>
</div>
</div>
<!-- Event Section -->
<div class="card">
<div class="card-header d-flex justify-content-between align-items-center">
<h5 class="mb-0">{{ __('Event') }}</h5>
@if (isset($setting['google_calendar_enable']) && $setting['google_calendar_enable'] == 'on')
<select class="form-control w-auto" name="calender_type" id="calender_type" onchange="get_data()">
<option value="goggle_calender">{{__('Google Calendar')}}</option>
<option value="local_calender" selected="true">{{__('Local Calendar')}}</option>
</select>
@endif
<input type="hidden" id="event_dashboard" value="{{url('/')}}">
</div>
<div class="card-body">
<div id='calendar' class='calendar e-height'></div>
</div>
</div>
</div>
<div class="col-xxl-6">
<!-- Announcement List Section -->
<div class="card list_card">
<div class="card-header">
<h5>{{__('Announcement List')}}</h5>
</div>
<div class="card-body dash-card-body">
<div class="table-responsive">
<table class="table table-striped mb-0">
<thead>
<tr>
<th class="text-left">{{__('Title')}}</th>
<th class="text-left">{{__('Start Date')}}</th>
<th class="text-left">{{__('End Date')}}</th>
<th class="text-left">{{__('Description')}}</th>
</tr>
</thead>
<tbody>
@forelse($announcements as $announcement)
<tr>
<td class="text-left">{{ $announcement->title }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($announcement->start_date) }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($announcement->end_date) }}</td>
<td class="text-left">{{ $announcement->description }}</td>
</tr>
@empty
<tr>
<td colspan="4" class="text-center">
<h6>{{__('There is no Announcement List')}}</h6>
</td>
</tr>
@endforelse
</tbody>
</table>
</div>
</div>
</div>
<!-- Meeting List Section -->
<div class="card list_card">
<div class="card-header">
<h5>{{__('Meeting List')}}</h5>
</div>
<div class="card-body dash-card-body">
@if(count($meetings) > 0)
<div class="table-responsive">
<table class="table align-items-center">
<thead>
<tr>
<th class="text-left">{{__('Meeting Title')}}</th>
<th class="text-left">{{__('Meeting Date')}}</th>
<th class="text-left">{{__('Meeting Time')}}</th>
</tr>
</thead>
<tbody>
@forelse($meetings as $meeting)
<tr>
<td class="text-left">{{ $meeting->title }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($meeting->date) }}</td>
<td class="text-left">{{ \Auth::user()->timeFormat($meeting->time) }}</td>
</tr>
@endforeach
</tbody>
</table>
</div>
@else
<div class="p-2 text-center">
{{__('No meeting scheduled yet.')}}
</div>
@endif
</div>
</div>
</div>
</div>
</div>
</div>
@else
<div class="row">
<div class="col-xxl-12">
<div class="card">
<div class="card-header">
<h5>{{__("Today's Not Clock In")}}</h5>
</div>
<div class="card-body">
<div class="row">
<div class="col-md-12">
<div class="d-flex gap-1 team-lists horizontal-scroll-cards justify-content-start">
@foreach($notClockIns as $notClockIn)
@php
$user = $notClockIn->user;
$logo = asset(Storage::url('uploads/avatar/'));
$avatar = !empty($notClockIn->user->avatar) ? $notClockIn->user->avatar : 'avatar.png';
@endphp
<div class="text-center">
<img src="{{ $logo . $avatar }}" alt="" class="rounded border-2 border border-primary">
<p class="mt-2 mb-1 p-0">{{ $notClockIn->name }}</p>
</div>
@endforeach
</div>
</div>
</div>
</div>
</div>
</div>
<div class="col-sm-12">
<div class="row">
<div class="col-xl-8 mb-4">
<div class="card h-100 mb-0">
<div class="card-header d-flex justify-content-between align-items-center">
<h5 class="mb-0">{{ __('Event') }}</h5>
@if(isset($setting['google_calendar_enable']) && $setting['google_calendar_enable'] == 'on')
<select class="form-control w-auto" name="calender_type" id="calender_type" onchange="get_data()">
<option value="goggle_calender">{{__('Google Calendar')}}</option>
<option value="local_calender" selected="true">{{__('Local Calendar')}}</option>
</select>
@endif
<input type="hidden" id="event_dashboard" value="{{url('/')}}">
</div>
<div class="card-body">
<div id='calendar' class='calendar'></div>
</div>
</div>
</div>
<div class="col-xl-4">
<div class="col-xxl-12">
<div class="card staff-info-card-wrp">
<div class="card-body p-3">
<h4 class="mb-3">{{__('Staff')}}</h4>
<div class="row row-gap-1">
<div class="col-xxl-6 col-xl-12 col-md-4 col-sm-6 col-12 staff-info-card">
<div class="staff-info-inner d-flex align-items-center gap-3">
<div class="staff-info-icon">
<svg width="24" height="14" viewBox="0 0 24 14" fill="none" xmlns="http://www.w3.org/2000/svg">
<!-- SVG content remains unchanged -->
</svg>
</div>
<div class="staff-info">
<p class="mb-1 dashboard-link">{{__('Total Staff')}}</p>
<h4 class="mb-0">{{ $countUser + $countClient }}</h4>
</div>
</div>
</div>
<!-- Other staff-info-card sections remain unchanged for brevity -->
</div>
</div>
</div>
</div>
<div class="col-xxl-12">
<div class="card staff-info-card-wrp">
<div class="card-body p-3">
<h4 class="mb-3">{{__('Job')}}</h4>
<div class="row row-gap-1">
<!-- Job info cards remain unchanged -->
</div>
</div>
</div>
</div>
<div class="col-xxl-12">
<div class="card staff-info-card-wrp">
<div class="card-body p-3">
<h4 class="mb-3">{{__('Training')}}</h4>
<div class="row row-gap-1">
<!-- Training info cards remain unchanged -->
</div>
</div>
</div>
</div>
</div>
<div class="col-lg-6 mb-4">
<div class="card h-100 mb-0">
<div class="card-header">
<h5>{{__('Announcement List')}}</h5>
</div>
<div class="card-body">
<div class="table-responsive">
@if(count($announcements) > 0)
<table class="table align-items-center">
<thead>
<tr>
<th class="text-left">{{__('Title')}}</th>
<th class="text-left">{{__('Start Date')}}</th>
<th class="text-left">{{__('End Date')}}</th>
</tr>
</thead>
<tbody class="list">
@foreach($announcements as $announcement)
<tr>
<td class="text-left">{{ $announcement->title }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($announcement->start_date) }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($announcement->end_date) }}</td>
</tr>
@endforeach
</tbody>
</table>
@else
<div class="p-2 text-center">
{{__('No announcement present yet.')}}
</div>
@endif
</div>
</div>
</div>
</div>
<div class="col-lg-6 mb-4">
<div class="card h-100 mb-0">
<div class="card-header">
<h5>{{__('Meeting Schedule')}}</h5>
</div>
<div class="card-body">
<div class="table-responsive">
@if(count($meetings) > 0)
<table class="table align-items-center">
<thead>
<tr>
<th class="text-left">{{__('Title')}}</th>
<th class="text-left">{{__('Date')}}</th>
<th class="text-left">{{__('Time')}}</th>
</tr>
</thead>
<tbody class="list">
@foreach($meetings as $meeting)
<tr>
<td class="text-left">{{ $meeting->title }}</td>
<td class="text-left">{{ \Auth::user()->dateFormat($meeting->date) }}</td>
<td class="text-left">{{ \Auth::user()->timeFormat($meeting->time) }}</td>
</tr>
@endforeach
</tbody>
</table>
@else
<div class="p-2 text-center">
{{__('No meeting scheduled yet.')}}
</div>
@endif
</div>
</div>
</div>
</div>
</div>
</div>
</div>
@endif
@endsection